\name{hamilton_depression_scale}
\alias{hamilton_depression_scale}
\title{
Hamilton Depression Rating Scale (HAM-D)
}
\description{
Calculates the HAM-D score (17-item version), the gold standard clinician-administered assessment for determining the severity of depression. It evaluates mood, vegetative functions, cognitive symptoms, and somatic complaints.
}
\usage{
hamilton_depression_scale(depressed_mood, guilt, suicide, insomnia_early,
                          insomnia_middle, insomnia_late, work_activities,
                          retardation, agitation, anxiety_psychic,
                          anxiety_somatic, somatic_gi, somatic_general,
                          genital_symptoms, hypochondriasis, weight_loss,
                          insight)
}
\arguments{
  \item{depressed_mood}{Numeric (0-4). Sadness, hopeless, helpless, worthless.}
  \item{guilt}{Numeric (0-4). Self-reproach, feeling that they have let people down.}
  \item{suicide}{Numeric (0-4). Thoughts that life is not worth living, suicidal ideas or attempts.}
  \item{insomnia_early}{Numeric (0-2). Difficulty falling asleep.}
  \item{insomnia_middle}{Numeric (0-2). Waking during the night.}
  \item{insomnia_late}{Numeric (0-2). Waking in early hours of the morning.}
  \item{work_activities}{Numeric (0-4). Thoughts/feelings of incapacity, loss of interest, decrease in actual time spent.}
  \item{retardation}{Numeric (0-4). Slowness of thought and speech, impaired ability to concentrate, decreased motor activity.}
  \item{agitation}{Numeric (0-4). Fidgeting, playing with hands/hair, moving about.}
  \item{anxiety_psychic}{Numeric (0-4). Subjective tension and irritability, worrying.}
  \item{anxiety_somatic}{Numeric (0-4). Physiological concomitants of anxiety (e.g., GI, CV, respiratory).}
  \item{somatic_gi}{Numeric (0-2). Loss of appetite, heavy feeling in abdomen, constipation.}
  \item{somatic_general}{Numeric (0-2). Heaviness in limbs, back, or head; loss of energy.}
  \item{genital_symptoms}{Numeric (0-2). Loss of libido, menstrual disturbances.}
  \item{hypochondriasis}{Numeric (0-4). Absorption in self, bodily concerns.}
  \item{weight_loss}{Numeric (0-2). Weight loss associated with present illness.}
  \item{insight}{Numeric (0-2). Acknowledgment of being depressed/ill.}
}
\details{
The standard 17-item scale is scored as follows:
\itemize{
  \item 0-7: Normal
  \item 8-13: Mild Depression
  \item 14-18: Moderate Depression
  \item 19-22: Severe Depression
  \item >=23: Very Severe Depression
}
}
\value{
A list containing:
\item{HAM_D_Score}{The calculated total score (Range 0-52).}
\item{Severity_Category}{Clinical interpretation of the score.}
}
\references{
Hamilton M. A rating scale for depression. J Neurol Neurosurg Psychiatry. 1960;23:56-62. doi:10.1136/jnnp.23.1.56
}
\examples{

# Example 1: Severe Depression
# High scores across mood, guilt, suicide, and somatic symptoms
hamilton_depression_scale(3, 3, 2, 2, 2, 2, 3, 2, 2, 2, 2, 1, 1, 1, 1, 1, 0)

# Example 2: Normal/Remission
# Minimal symptoms
hamilton_depression_scale(0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0)
}
