\name{heart_score_mace}
\alias{heart_score_mace}
\title{
HEART Score for Major Cardiac Events (MACE)
}
\description{
Calculates the HEART Score to predict the 6-week risk of Major Adverse Cardiac Events (MACE) in patients presenting with chest pain. The score uses five variables: History, ECG, Age, Risk factors, and Troponin. It stratifies patients into Low, Moderate, and High risk groups to guide disposition (discharge vs. admission).
}
\usage{
heart_score_mace(history_suspicion, ecg_findings, age, risk_factors_count,
                 history_atherosclerosis, troponin_limit_multiplier)
}
\arguments{
  \item{history_suspicion}{
Numeric (0, 1, or 2). Clinical suspicion based on history.
0: Slightly suspicious.
1: Moderately suspicious.
2: Highly suspicious.
}
  \item{ecg_findings}{
Numeric (0, 1, or 2). ECG interpretation.
0: Normal.
1: Non-specific repolarization disturbance / LBBB / PM.
2: Significant ST depression.
}
  \item{age}{
Numeric. Patient age in years.
<45: 0 pts.
45-64: 1 pt.
>=65: 2 pts.
}
  \item{risk_factors_count}{
Numeric. Count of cardiovascular risk factors (HTN, Hyperlipidemia, Diabetes, Family Hx, Smoking, Obesity).
}
  \item{history_atherosclerosis}{
Numeric (0 or 1). History of atherosclerotic disease (e.g., prior MI, PCI, CABG, CVA/TIA, or PAD). (1 = Yes).
Note: If Risk Factors count >= 3 OR History is Yes -> 2 points. If Risk Factors 1-2 -> 1 point.
}
  \item{troponin_limit_multiplier}{
Numeric. Patient's initial troponin level divided by the normal limit (e.g., if limit is 0.04 and patient is 0.06, input 1.5).
<=1x: 0 pts.
1-2x: 1 pt.
>2x: 2 pts.
}
}
\value{
A list containing:
\item{HEART_Score}{The calculated total score (Range 0-10).}
\item{Risk_Category}{Classification (Low 0-3, Moderate 4-6, High 7-10).}
\item{MACE_Risk_6_Weeks}{Estimated risk of MACE within 6 weeks.}
\item{Recommendation}{Clinical guidance based on risk category.}
}
\references{
Six AJ, Backus BE, Kelder JC. Chest pain in the emergency room: value of the HEART score. Neth Heart J. 2008;16(6):191-196.
Backus BE, Six AJ, Kelder JC, et al. A prospective validation of the HEART score for chest pain patients at the emergency department. Int J Cardiol. 2013;168(3):2153-2158. doi:10.1016/j.ijcard.2013.01.255
}
\examples{

# Example 1: Low Risk
# Slight suspicion (0), Normal ECG (0), 40yo (0), 1 Risk Factor (1), Normal Trop (0.5x)
# Score = 1
heart_score_mace(0, 0, 40, 1, 0, 0.5)

# Example 2: High Risk
# Highly suspicious (2), ST depression (2), 70yo (2), 3 Risk Factors (2), Trop 3x (2)
# Score = 10
heart_score_mace(2, 2, 70, 3, 0, 3.0)
}
