\name{killip_classification}
\alias{killip_classification}
\title{
Killip Classification for Heart Failure in Acute MI
}
\description{
Retrieves the clinical description and estimated mortality risk for the Killip Classification. This system stratifies patients with acute myocardial infarction based on the severity of heart failure presentation, ranging from no signs of failure (Class I) to cardiogenic shock (Class IV).
}
\usage{
killip_classification(class_grade)
}
\arguments{
  \item{class_grade}{
Numeric (1-4). The Killip Class assigned to the patient.
1: No evidence of heart failure.
2: Findings consistent with mild-to-moderate heart failure (S3 gallop, rales < half lung fields, elevated JVD).
3: Frank pulmonary edema.
4: Cardiogenic shock.
}
}
\value{
A list containing:
\item{Killip_Class}{The formatted class string.}
\item{Clinical_Findings}{Description of the physical exam findings associated with the class.}
\item{Estimated_30_Day_Mortality}{Estimated mortality risk based on the original 1967 data.}
}
\references{
Killip T 3rd, Kimball JT. Treatment of myocardial infarction in a coronary care unit. A two year experience with 250 patients. Am J Cardiol. 1967;20(4):457-464. doi:10.1016/0002-9149(67)90023-9
}
\examples{

# Example 1: Class I (No HF)
killip_classification(1)

# Example 2: Class IV (Cardiogenic Shock)
killip_classification(4)
}
