\name{kinetic_egfr}
\alias{kinetic_egfr}
\title{
Kinetic Estimated Glomerular Filtration Rate (KeGFR)
}
\description{
Calculates the Kinetic eGFR, a metric that adjusts the standard eGFR for rapid changes in serum creatinine levels. This provides a more accurate estimation of renal function in the context of Acute Kidney Injury (AKI), where creatinine production and excretion are not in steady state. The Baseline eGFR is calculated internally using the CKD-EPI 2021 (Race-Free) equation.
}
\usage{
kinetic_egfr(initial_creatinine, final_creatinine, time_hours,
             baseline_creatinine, age, sex, weight_kg)
}
\arguments{
  \item{initial_creatinine}{
Numeric. The first serum creatinine measurement in the interval (mg/dL).
}
  \item{final_creatinine}{
Numeric. The second serum creatinine measurement in the interval (mg/dL).
}
  \item{time_hours}{
Numeric. The time elapsed between the initial and final creatinine measurements in hours.
}
  \item{baseline_creatinine}{
Numeric. The patient's stable baseline serum creatinine (mg/dL). This is used to estimate the steady-state creatinine production rate.
}
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms. Used to estimate the volume of distribution (Total Body Water).
}
}
\value{
A list containing:
\item{Kinetic_eGFR}{The calculated kinetic GFR in mL/min/1.73m^2.}
\item{Baseline_eGFR}{The steady-state eGFR derived from the baseline creatinine.}
}
\references{
Chen S. Retooling the Creatinine Clearance Equation to Estimate Kinetic GFR when the Plasma Creatinine Is Changing acutely. J Am Soc Nephrol. 2013;24(6):877-888. doi:10.1681/ASN.2012070653
}
\examples{

# Example 1: Developing AKI
# Cr rose from 1.0 to 1.5 over 24 hours. Baseline was 1.0.
# Age 60, Male, 80kg
kinetic_egfr(1.0, 1.5, 24, 1.0, 60, "male", 80)

# Example 2: Recovery from AKI
# Cr fell from 3.0 to 2.0 over 24 hours. Baseline was 1.0.
# Age 60, Male, 80kg
kinetic_egfr(3.0, 2.0, 24, 1.0, 60, "male", 80)
}
