\name{liver_decompensation_risk_hcc}
\alias{liver_decompensation_risk_hcc}
\title{
Liver Decompensation Risk after Hepatectomy for HCC
}
\description{
Calculates the risk of liver decompensation and liver-related mortality after partial hepatectomy for Hepatocellular Carcinoma (HCC). This hierarchical model stratifies patients into Low, Intermediate, and High risk categories based on the presence of portal hypertension, the extent of resection, and the MELD score.
}
\usage{
liver_decompensation_risk_hcc(portal_hypertension, extent_hepatectomy,
                              meld_score)
}
\arguments{
  \item{portal_hypertension}{
Numeric (0 or 1). Presence of clinically significant portal hypertension (e.g., esophageal varices, splenomegaly with platelets <100,000/uL). (1 = Yes).
}
  \item{extent_hepatectomy}{
String. Planned extent of liver resection.
"minor": Removal of < 3 adjacent segments.
"major": Removal of >= 3 adjacent segments.
}
  \item{meld_score}{
Numeric. Model for End-Stage Liver Disease (MELD) score (or MELD-Na). Threshold for risk stratification is > 9.
}
}
\value{
A list containing:
\item{Risk_Category}{Classification (Low, Intermediate, High).}
\item{Est_Liver_Decompensation_Rate}{Estimated probability of postoperative liver decompensation.}
\item{Est_Liver_Related_Mortality}{Estimated probability of liver-related mortality.}
}
\references{
Citterio D, Facciorusso A, Sposito C, et al. Hierarchic Interaction of Factors Associated With Liver Decompensation After Resection for Hepatocellular Carcinoma. JAMA Surg. 2016;151(10):908-916. doi:10.1001/jamasurg.2016.1121
}
\examples{

# Example 1: High Risk
# Portal HTN, Major Resection
liver_decompensation_risk_hcc(1, "major", 8)

# Example 2: Intermediate Risk
# No Portal HTN, Major Resection
liver_decompensation_risk_hcc(0, "major", 8)

# Example 3: Low Risk
# No Portal HTN, Minor Resection, MELD 8
liver_decompensation_risk_hcc(0, "minor", 8)
}
