\name{rems_score}
\alias{rems_score}
\title{
Rapid Emergency Medicine Score (REMS)
}
\description{
Calculates the Rapid Emergency Medicine Score (REMS) to predict in-hospital mortality in non-surgical emergency department patients. The score is an adaptation of the APACHE II score but relies on only six readily available parameters: age, heart rate, respiratory rate, systolic blood pressure, Glasgow Coma Scale (GCS), and oxygen saturation.
}
\usage{
rems_score(age_years, heart_rate, respiratory_rate, systolic_bp, gcs_score,
           oxygen_saturation)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score (3-15).
}
  \item{oxygen_saturation}{
Numeric. Peripheral oxygen saturation (SpO2) percentage.
}
}
\value{
A list containing:
\item{REMS_Score}{The calculated total score (Range 0-26).}
\item{Mortality_Risk}{Estimated mortality risk category.}
}
\references{
Olsson T, Terent A, Lind L. Rapid Emergency Medicine Score: a new prognostic tool for in-hospital mortality in nonsurgical emergency department patients. J Intern Med. 2004;255(5):579-587. doi:10.1111/j.1365-2796.2004.01321.x
}
\examples{

# Example 1: Low Risk
# 40yo, HR 80, RR 16, SBP 120, GCS 15, SpO2 98
# Score = 0
rems_score(40, 80, 16, 120, 15, 98)

# Example 2: High Risk
# 70yo (+5), HR 120 (+2), RR 28 (+2), SBP 100 (0), GCS 12 (+2), SpO2 88 (+1)
# Score = 12
rems_score(70, 120, 28, 100, 12, 88)
}
