% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_sections.R
\name{split_into_sections}
\alias{split_into_sections}
\title{Split document text into sections}
\usage{
split_into_sections(text, file_path = NULL)
}
\arguments{
\item{text}{Character string. Full text of the document.}

\item{file_path}{Character string or NULL. Path to PDF file for TOC extraction.
If NULL, uses common section names. Default is NULL.}
}
\value{
Named list where each element is a section's text. Always includes
"Full_text" element with complete document.
}
\description{
Splits extracted text into logical sections (Introduction, Methods, Results, etc.)
using either the PDF's table of contents or common academic section patterns.
}
\details{
The function attempts to:
\enumerate{
\item Extract section names from PDF table of contents
\item Fall back to common academic section names if TOC unavailable
\item Match section headers in text using regex patterns
\item Handle duplicate section names
}

Common sections searched: Abstract, Introduction, Methods, Results,
Discussion, Conclusion, References, etc.
}
\examples{
\dontrun{
text <- pdf2txt_auto("paper.pdf", sections = FALSE)
sections <- split_into_sections(text, file_path = "paper.pdf")
names(sections)
}

}
