% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.r
\name{read_bigbed}
\alias{read_bigbed}
\title{Read data from bigBed files.}
\usage{
read_bigbed(bbfile, chrom = NULL, start = NULL, end = NULL)
}
\arguments{
\item{bbfile}{filename for bigBed file}

\item{chrom}{read data for specific chromosome}

\item{start}{start position for data}

\item{end}{end position for data}
}
\value{
\code{tibble}
}
\description{
Columns are automatically typed based on the autoSql schema embedded
in the bigBed file. Integer types (\code{uint}, \code{int}) become R integers,
floating point types (\code{float}, \code{double}) become R doubles, and all
other types (including array types like \code{int[blockCount]}) remain
as character strings.
}
\examples{
bb <- system.file("extdata", "test.bb", package = "cpp11bigwig")

read_bigbed(bb)

read_bigbed(bb, chrom = "chr10")

}
\seealso{
\url{https://github.com/dpryan79/libBigWig}

\url{https://github.com/brentp/bw-python}
}
