% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cn.R
\name{cn}
\alias{cn}
\alias{cn.cpr_bt}
\alias{cn.formula}
\title{Control Nets}
\usage{
cn(x, ...)

\method{cn}{cpr_bt}(x, theta, ...)

\method{cn}{formula}(
  formula,
  data,
  method = stats::lm,
  method.args = list(),
  keep_fit = TRUE,
  check_rank = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{cpr_bt} object}

\item{...}{pass through}

\item{theta}{a vector of (regression) coefficients, the ordinates of the
control net.}

\item{formula}{a formula that is appropriate for regression method being used.}

\item{data}{a required \code{data.frame}}

\item{method}{the regression method such as \code{\link[stats]{lm}},
\code{\link[stats]{glm}}, \code{\link[lme4]{lmer}}, etc.}

\item{method.args}{a list of additional arguments to pass to the regression
method.}

\item{keep_fit}{(logical, defaults to \code{FALSE}).  If \code{TRUE} the
regression model fit is retained and returned in the \code{fit} element.
If \code{FALSE} the regression model is not saved and the \code{fit} element
will be \code{NA}.}

\item{check_rank}{(logical, defaults to \code{TRUE}) if TRUE check that the
design matrix is full rank.}
}
\value{
a \code{cpr_cn} object.  This is a list with the following elements.
Some of the elements are omitted when using the \code{cn.cpr_bt} method.
\describe{
 \item{cn}{the control net, \code{data.frame} with each row defining a vertex
 of the control net}
 \item{bspline_list}{A list of the marginal B-splines}
 \item{call}{the call}
 \item{keep_fit}{logical, indicates if the regression model was retained}
 \item{fit}{if \code{isTRUE(keep_fit)} then the regression model is here,
 else \code{NA}.}
 \item{coefficients}{regression coefficients, only the fixed effects if a
 mixed effects model was used.}
 \item{vcov}{The variance-covariance matrix for the \code{coefficients}}
 \item{loglik}{The log-likelihood for the regression model}
 \item{rse}{the residual standard error for the regression model}
 }
}
\description{
Generate the control net for a univariate B-spline
}
\details{
\code{cn} generates the control net for the given B-spline function.  There
are several methods for building a control net.
}
\examples{

acn <- cn(log10(pdg) ~
              btensor(   x     = list(day, age)
                      , df     = list(30, 4)
                      , bknots = list(c(-1, 1), c(44, 53))
              )
           , data = spdg)
str(acn, max.level = 1)

}
\seealso{
\code{\link{summary.cpr_cn}}, \code{\link{cnr}},
\code{\link{plot.cpr_cn}} for plotting control nets
}
