% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario_refi.R
\name{test_refi}
\alias{test_refi}
\title{Test the feasibility of a refinancing at year T (interest-only diagnostic)}
\usage{
test_refi(full, year_T, covenants, new_rate, new_exit_yield)
}
\arguments{
\item{full}{data.frame. Merged table (0..N) from \code{\link[=cf_make_full_table]{cf_make_full_table()}},
containing at least: \code{year}, \code{net_operating_income}, \code{outstanding_debt}.}

\item{year_T}{integer(1). Evaluation year \(T\) (0..N).}

\item{covenants}{list. Thresholds: \code{dscr_min} (default 1.25),
\code{ltv_max} (default 0.65).}

\item{new_rate}{numeric(1). New annual nominal rate (decimal).}

\item{new_exit_yield}{numeric(1). New exit yield (decimal) for forward value.
\verb{NOI_\{T+1\}} is missing (default 0 if not provided as an attribute of \code{full}
or in the DCF inputs).}
}
\value{
list with \code{status} ("ok"/"fail"), \code{reasons} (character) and \code{snapshot} (tibble).
}
\description{
Assesses at \(T\) the simultaneous feasibility of DSCR and forward LTV
covenants assuming an interest-only payment at \(T+1\). This diagnostic
isolates covenant feasibility from the precise structure of the new loan.
}
