% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsRelativeParts-class}
\alias{IncrementsRelativeParts-class}
\alias{.IncrementsRelativeParts}
\alias{IncrementsRelativeParts}
\alias{.DefaultIncrementsRelativeParts}
\title{\code{IncrementsRelativeParts}}
\usage{
IncrementsRelativeParts(dlt_start, clean_start, ...)

.DefaultIncrementsRelativeParts()
}
\arguments{
\item{dlt_start}{(\code{count})\cr see slot definition.}

\item{clean_start}{(\code{count})\cr see slot definition.}

\item{...}{
  Arguments passed on to \code{\link[=IncrementsRelative]{IncrementsRelative}}
  \describe{
    \item{\code{intervals}}{(\code{numeric})\cr see slot definition.}
    \item{\code{increments}}{(\code{numeric})\cr see slot definition.}
  }}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{IncrementsRelativeParts}} is the class for increments control based on
relative differences in intervals, with special rules for part 1 and
beginning of part 2.
}
\details{
This class works only in conjunction with \code{\link{DataParts}} objects. If
part 2 will just be started in the next cohort, then the next maximum dose
will be either \code{dlt_start} (e.g. -1) shift of the last part 1 dose in case
of a DLT in part 1, or \code{clean_start} shift (e.g. -1) in case of no DLTs in
part 1, given that \code{clean_start <= 0} (see description of \code{clean_start}
slot for more details). If part 1 will still be on in the next cohort,
then the next dose level will be the next higher dose level in the
\code{part1Ladder} slot of the data object. If part 2 has been started before,
the usual relative increment rules apply, see \code{\link{IncrementsRelative}}.
}
\section{Slots}{

\describe{
\item{\code{dlt_start}}{(\code{integer})\cr a scalar, the dose level increment for starting
part 2 in case of at least one DLT event in part 1.}

\item{\code{clean_start}}{(\code{integer})\cr a scalar, the dose level increment for
starting part 2 in case of no DLTs in part 1. If \code{clean_start <= 0},
then the part 1 ladder will be used to find the maximum next dose.
Otherwise, the relative increment rules will be applied to find the next
maximum dose level.}
}}

\note{
We require that \code{clean_start >= dlt_start}. However, this precondition
is not a prerequisite for any function (except of the class' validation
function) that works with objects of this class. It is rather motivated by
the semantics. That is, if we observe a DLT in part 1, we cannot be more
aggressive than in case of a clean part 1 without DLT.

Typically, end users will not use the \code{.DefaultIncrementsRelativeParts()} function.
}
\examples{
my_increments <- IncrementsRelativeParts(dlt_start = 0, clean_start = 1)
}
