% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCoverageCheck.R
\name{ctModelCoverage_check}
\alias{ctModelCoverage_check}
\title{Coverage Check Function}
\usage{
ctModelCoverage_check(
  initialData,
  fitting_model,
  niter,
  fit_args,
  cores = 10,
  plot_every = max(c(10, cores))
)
}
\arguments{
\item{initialData}{An initial dataset to fit to determine 'true' parameters for further generation.}

\item{fitting_model}{A ctModel object used for fitting the data}

\item{niter}{Number of iterations to run}

\item{fit_args}{Named list of fit argument sets to test 
(e.g., list(boot = list(optimcontrol = list(bootstrapUncertainty = TRUE)), 
hess = list(optimcontrol = list(bootstrapUncertainty = FALSE))))}

\item{cores}{Number of cores to use for parallel processing}

\item{plot_every}{Print plots every n iterations (default = 10)}
}
\value{
A list containing the results data.table and final plots
}
\description{
Performs a coverage check analysis by generating data from a model, fitting it multiple times
with different fit arguments, and plotting the results.
}
