% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_pieplot}
\alias{plot_pieplot}
\title{Plot pie}
\usage{
plot_pieplot(
  data,
  label_x = "",
  label_y = "",
  colors = NULL,
  textcolor = "white",
  bordercolor = "black"
)
}
\arguments{
\item{data}{two‑column data.frame with category and value}

\item{label_x}{x‑axis label (unused in pie, kept for symmetry)}

\item{label_y}{y‑axis label (unused in pie)}

\item{colors}{vector of slice fills}

\item{textcolor}{label text color}

\item{bordercolor}{slice border color}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Pie chart from a two‑column data.frame (category, value) using polar coordinates.
}
\details{
Slices are sized by the second (numeric) column. Text and border colors can be customized.
}
\examples{
#summarizing iris dataset
data <- iris |> dplyr::group_by(Species) |>
dplyr::summarize(Sepal.Length=mean(Sepal.Length))
head(data)

#ploting data
grf <- plot_pieplot(data, colors=c("red", "green", "blue"))
plot(grf)
}
