% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNWISdata.R
\name{countyCdLookup}
\alias{countyCdLookup}
\title{US county code look up}
\usage{
countyCdLookup(state, county, outputType = "fips")
}
\arguments{
\item{state}{could be character (full name, abbreviation, id), or numeric (id)}

\item{county}{could be character (name, with or without "County") or numeric (id)}

\item{outputType}{character can be "fullName", "tableIndex", "id", or "fullEntry".}
}
\description{
Function to simplify finding county and county code definitions. Used in \code{readNWISdata}
and \code{readNWISuse}. Currently only has US counties.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}
\donttest{

fips <- countyCdLookup(state = "WI", county = "Dane")
id <- countyCdLookup(state = "WI", county = "Dane", outputType = "id")
name <- countyCdLookup(state = "OH", county = 13, output = "fullName")
entry <- countyCdLookup(state = "Pennsylvania", county = "ALLEGHENY COUNTY", output = "fullEntry")
fromIDs <- countyCdLookup(state = 13, county = 5, output = "fullName")
}
\dontshow{\}) # examplesIf}
}
