% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stats.R
\name{summary_stats_rt}
\alias{summary_stats_rt}
\title{Compute summary statistics of reaction times}
\usage{
summary_stats_rt(data)
}
\arguments{
\item{data}{A data frame or a database table with reaction times dataset. Required columns are \code{epoch} and \code{RT} (value of reaction time in ms).
Optional columns: \code{group}, \code{subject}, \code{condition} for computing summary statistics per group/subject/condition.}
}
\value{
A tibble with summary statistics of reaction times consisting of the following columns:
\describe{
\item{group}{Group identifier (only if present in the input data).}
\item{subject}{Subject identifier (only if present in the input data).}
\item{condition}{Experimental condition (only if present in the input data).}
\item{n_epoch}{Number of epochs.}
\item{min_rt}{Minimum reaction time.}
\item{max_rt}{Maximum reaction time.}
\item{median_rt}{Median reaction time.}
\item{avg_rt}{Mean reaction time.}
\item{sd_rt}{Standard deviation of reaction time.}
}
}
\description{
Calculates basic descriptive statistics of reaction time (RT).
Statistics are computed separately for each combination of grouping variables present in the data (e.g., group, subject, condition).

Computed statistics include: the number of epochs, minimum, maximum, median, mean, and standard deviation of RT.
}
\examples{
# 1. Summary statistics for rtdata
# two different subjects, no group or conditions - results are computed per subject
summary_stats_rt(rtdata)

# 2. Summary statistics for data with conditions
# a) create example data
data_cond <- rtdata
data_cond$condition <- c(rep("a", 7), rep("b", 7), rep("a", 8), rep("b",7))
# b) compute statistics per subject and condition
summary_stats_rt(data_cond)
# c) compute statistics per conditions regardless of subjects
# exclude "subject" column from computing
summary_stats_rt(data_cond[,-1])
}
