% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_simulator_inputs.R
\name{check_simulator_inputs}
\alias{check_simulator_inputs}
\title{Helper function to check the validity of inputs to the \code{disease_simulator}
function.}
\usage{
check_simulator_inputs(inputs)
}
\arguments{
\item{inputs}{Nested list/object with named elements:
\describe{
\item{\code{random_seed}}{Number to seed the random number generation for
stochasticity.}
\item{\code{replicates}}{Number of replicate simulation runs (default is
1.)}
\item{\code{time_steps}}{Number of simulation years. Required input.}
\item{\code{seasons}}{Number of seasons per year (default is 2.)}
\item{\code{populations}}{Number of populations. Required input.}
\item{\code{coordinates}}{Data frame (or matrix) of X-Y population
coordinates.}
\item{\code{stages}}{Number of life cycle stages. Default: 1.}
\item{\code{compartments}}{Number of disease compartments (e.g., 3 for a
SIR model). Default: 1.}
\item{\code{region}}{A \code{\link[poems:Region]{poems::Region}} object
defining the study region.}
\item{\code{initial_abundance}}{Array (or matrix) of initial abundances.
There must be one column per population and one row per compartment/stage
combination. By default, this should be in the order compartment by stage,
e.g., 2 stage classes plus a SI model should be ordered as S1, S2, I1, I2.
If a region object is attached, then initial abundance may be provided in
the form of a raster with the same specs as the region raster and one
layer per stage/compartment combination. If there is only one
stage/compartment combination you may provide a vector with length
\code{populations}. Required input.}
\item{\code{carrying_capacity}}{Array (matrix) of carrying capacity values
at each population cell (\code{populations} rows by \code{time_steps}
columns when across time). Required input.}
\item{\code{breeding_season_length}}{Array (matrix) of breeding season
length values in days at each population cell (\code{populations} rows by
\code{time_steps} columns when across time). Can also be a vector of length
\code{populations} if the breeding season length does not change over
time.}
\item{\code{season_lengths}}{Vector of season lengths in days. Length must
equal \code{seasons}. If neither \code{breeding_season_length} nor
\code{season_lengths} are provided, season lengths will default to
\code{365/seasons}.}
\item{\code{correlation}}{List containing either an environmental
correlation matrix (correlation_matrix), a pre-calculated transposed
(Cholesky) decomposition matrix (t_decomposition_matrix), or a compact
transposed (Cholesky) decomposition matrix (t_decomposition_compact_matrix)
and a corresponding map of population indices (t_decomposition_compact_map),
as per \code{\link[poems:SpatialCorrelation]{poems::SpatialCorrelation}} class attributes.}
\item{\code{mortality}}{A vector of mortality rates, one for each
combination of stages and compartments. Assumed by default to be daily
mortality rates unless indicated otherwise (see below). If mortality varies
by season, a list of mortality vectors with the same length as \code{seasons}
may be provided instead. Required input.}
\item{\code{mortality_unit}}{A vector indicating whether mortality rates are
daily or seasonal. 1 indicates seasonal, 0 indicates daily. Default: all 0.
A list of vectors may be provided if this varies by season.}
\item{\code{fecundity}}{A vector of fecundity rates, one for each
combination of stages and compartments for which fecundity applies (see
\code{fecundity_mask} below). If fecundity varies among seasons, a list of
fecundity vectors with the same length as \code{seasons} may be provided.
Required input.}
\item{\code{fecundity_unit}}{A vector indicating whether fecundity rates are
daily or seasonal. 1 indicates seasonal, 0 indicates daily. Default: all 0.
A list of vectors may be provided if this varies by season.}
\item{\code{fecundity_mask}}{A vector indicating which stages and
compartments reproduce. Must be the same length as
\code{stages * compartments}. A list of vectors may be provided if this
varies by season. If no fecundity mask is provided, then it is assumed that
all stages and compartments reproduce.}
\item{\code{abundance_threshold}}{A quasi-extinction threshold at which a
population becomes extinct. Default: 0.}
\item{\code{demographic_stochasticity}}{Boolean for choosing demographic
stochasticity for transition, dispersal, and/or other processes (default is
TRUE).}
\item{\code{transmission}}{A vector of transmission rates, one for each
combination of stages and compartment for which transmission applies (see
\code{transmission_mask} below). If transmission varies by season, a list of
transmission vectors with the same length as \code{seasons} may be provided
instead. Required input.}
\item{\code{transmission_unit}}{A vector indicating whether transmission
is daily or seasonal. 1 indicates seasonal, 0 indicates daily. Default: all
0. A list of vectors may be provided if this varies by season.}
\item{\code{transmission_mask}}{A vector indicating which stages and
compartments are subject to transmission (i.e., classes susceptible to
infection.) Must be the same length as \code{compartments}. A list of
vectors may be provided if this varies by season. If no transmission mask is
provided, then it is assumed that all stages in the first compartment are
susceptible to infection.}
\item{\code{recovery}}{A vector of recovery rates, one for each
combination of stages and compartment for which recovery applies (see
\code{recovery_mask} below.) If recovery varies by season, a list of
recovery vectors the same length as \code{seasons} may be provided instead.}
\item{\code{recovery_unit}}{A vector
indicating whether recovery rates are daily or seasonal. 1 indicates
seasonal, 0 indicates daily. Default: all 0. A list of vectors may be
provided if this varies by season.}
\item{\code{recovery_mask}}{A
vector indicating which compartments are subject to recovery (i.e., infected
classes that can recover.) Must be the same length as \code{compartments}.
A list of vectors may be provided if this varies by season. If no recovery
mask is provided, then it is assumed that all stages in the second
compartment can recover, if there is a second compartment.}
\item{\code{dispersal}}{A list that is either length 1 or the same length as
\code{stages}. If it is length 1, the same dispersal will be applied across
all stages. Within each element of the list, there should be either a function,
a matrix of dispersal rates between populations (source columns to target
rows) or a list of data frames of non-zero dispersal rates and indices for
constructing a compact dispersal matrix, and optional changing rates over
time (as per class \code{\link[poems:DispersalGenerator]{poems::DispersalGenerator}} \emph{dispersal_data}
attribute).}
\item{\code{dispersal_source_n_k}}{Dispersal proportion (p) density
dependence via source population abundance divided by carrying capacity
(n/k), where p is reduced via a linear slope (defined by two list items)
from n/k <= \emph{cutoff} (p = 0) to n/k \>= \emph{threshold} (aliases:
\emph{dispersal_n_k_cutoff} & \emph{dispersal_n_k_threshold}).}
\item{\code{dispersal_target_k}}{Dispersal rate (r) density dependence via
target population carrying capacity (k), where r is reduced via a linear
slope (through the origin) when k <= \emph{threshold} (alias:
\emph{dispersal_k_threshold}).}
\item{\code{dispersal_target_n}}{Dispersal
rate (r) density dependence via target population abundance (n), where r is
reduced via a linear slope (defined by two list items) from n \>=
\emph{threshold} to n <= \emph{cutoff} (r = 0) or vice versa (aliases:
\emph{dispersal_n_threshold} & \emph{dispersal_n_cutoff}).}
\item{\code{dispersal_target_n_k}}{Dispersal rate (r) density dependence via
target population abundance divided by carrying capacity (n/k), where r is
reduced via a linear slope (defined by two list items) from n/k \>=
\emph{threshold} to n/k <= \emph{cutoff} (r = 0) or vice versa.}
\item{\code{season_functions}}{A list of population transformation functions
(functions that change abundance across stages and compartments) the same
length as \code{seasons.} The function must be in the form
\code{function(params)}, where \code{params} is a list passed to the
function containing:
\describe{
\item{\code{replicates}}{Number of replicate simulation runs
(default is 1.)}
\item{\code{time_steps}}{Number of simulation years. Required
input.}
\item{\code{seasons}}{Number of seasons per year (default is 2.)}
\item{\code{populations}}{Number of populations. Required input.}
\item{\code{stages}}{Number of life cycle stages. Default: 1.}
\item{\code{compartments}}{Number of disease compartments (e.g., 3
for a SIR model). Default: 1.}
\item{\code{breeding_season_length}}{Array (matrix) of breeding
season length values in days at each population cell
(\code{populations} rows by \code{time_steps} columns when across
time).}
\item{\code{season_lengths}}{Vector of season lengths in days.
Length must equal \code{seasons}.}
\item{\code{mortality}}{A vector of mortality rates, one for each
combination of stages and compartments. Assumed by default to be
daily mortality rates. Required input.}
\item{\code{mortality_unit}}{A vector indicating whether mortality
rates are daily or seasonal. 1 indicates seasonal, 0 indicates
daily. Default: all 0.}
\item{\code{fecundity}}{A vector of fecundity rates, one for each
combination of stages and compartments for which fecundity applies
(see \code{fecundity_mask} below). Required input.}
\item{\code{fecundity_unit}}{A vector indicating whether mortality
rates are daily or seasonal. 1 indicates seasonal, 0 indicates
daily. Default: all 0.}
\item{\code{fecundity_mask}}{A vector indicating which stages and
compartments reproduce. Must be the same length as
\code{stages * compartments}.}
\item{\code{abundance_threshold}}{A quasi-extinction threshold below
which a population becomes extinct. Default: 0.}
\item{\code{demographic_stochasticity}}{Boolean for choosing
demographic stochasticity for transition, dispersal, and/or other
processes (default is TRUE).}
\item{\code{transmission}}{A vector of transmission rates, one for
each combination of stages and compartments. Assumed by default to
be daily transmission rates. Required input.}
\item{\code{transmission_unit}}{A vector indicating whether
mortality rates are daily or seasonal. 1 indicates seasonal, 0
indicates daily. Default: all 0.}
\item{\code{recovery}}{A vector of recovery rates, one for each
combination of stages and compartment for which recovery applies
(see \code{recovery_mask} below.)}
\item{\code{recovery_unit}}{A vector indicating whether mortality
rates are daily or seasonal. 1 indicates seasonal, 0 indicates
daily. Default: all 0.}
\item{\code{recovery_mask}}{A vector indicating which compartments
are subject to recovery (i.e., infected classes that can recover.)
Must be the same length as \code{compartments}.}
\item{\code{r}}{Simulation replicate.}
\item{\code{tm}}{Simulation time step.}
\item{\code{carrying_capacity}}{Array of carrying capacity values
for each population at time step.}
\item{\code{segment_abundance}}{Matrix of abundance for each
combination of stage and compartment (rows) and population (columns)
at time step.}
\item{\code{occupied_indices}}{Array of indices for populations
occupied at time step.}
\item{\code{simulator}}{\code{\link[poems:SimulatorReference]{poems::SimulatorReference}} object
with dynamically accessible \emph{attached} and \emph{results}
lists.}
\item{\code{additional attributes}}{Additional attributes when the
transformation is optionally nested in a list.}
}
and returns a transformed stage abundance matrix.}
\item{\code{simulation_order}}{A list the same length as \code{seasons}.
Each element in the list is a vector of named simulation processes in the
desired order. Processes must be one of "transition", "dispersal",
"season_functions", or "results."}
\item{\code{dispersal_type}}{A character vector that may contain "pooled"
(if all individuals disperse the same), "stages", "compartments", or
"segments", if different stages, compartments, or stage-compartment
combinations disperse differently. If "pooled" is chosen,
\code{dispersal} must be a list of length 1. If "stages" is chosen, it
must be the same length as \code{stages}, if "compartments" is chosen,
it must be the same length as \code{compartments}, and if "segments" is
chosen, it must be the same length as stages*compartments. The default
value is "pooled".}
\item{\code{results_selection}}{List of results selection from: "abundance"
(default), "ema", "extirpation", "extinction_location",
"occupancy"; "summarize" (default) or "replicate".}
\item{\code{results_breakdown}}{A string with one of these values:
"segments" (default),
"compartments", "stages" or "pooled." "segments" returns results for each
segment (stage x compartment combination.) "compartments" returns results for
each disease compartment. "stages" returns results for each life cycle stage.
"pooled" returns results that are not broken down by stage or compartment.}
\item{\code{verbose}}{TRUE or FALSE, indicating if the user wants informative
messages throughout the simulation process.}
}}
}
\value{
A list identical to the inputs, except with default values supplied
to fill in any crucial missing values, as explained in the documentation
above.
}
\description{
This is an internal function that checks inputs to the \code{disease_simulator}
function to make sure they are valid, and sets default values for needed
inputs if their values are not supplied. The possible inputs for this
function are the same as the possible inputs to the \code{disease_simulator}
function.
}
