test_that("EGARCH family model orders are correctly specified", {
  expect_false(order_checker(c(1, 1)))
  expect_false(order_checker(c(2, 1)))
  expect_false(order_checker(c(1, 2)))
  expect_false(!order_checker(c(0, 0)))
  expect_false(!order_checker(c(0, 1)))
  expect_false(!order_checker(c(1, 0)))
  expect_false(!order_checker(c(1)))
  expect_false(!order_checker(c(1, 0, 1)))
  expect_false(!order_checker(numeric(0)))
})

test_that("EGARCH family model powers are correctly specified", {
  expect_false(power_checker(c(1, 1)))
  expect_false(power_checker(c(0, 0)))
  expect_false(power_checker(c(1, 0)))
  expect_false(power_checker(c(0, 1)))
  expect_false(power_checker(c(0.5, 0.5)))
  expect_false(power_checker(c(0.5, 1)))
  expect_false(power_checker(c(1, 0.5)))
  expect_false(!power_checker(c(1)))
  expect_false(!power_checker(c(1, 0.5, 0)))
  expect_false(!power_checker(numeric(0)))
})

test_that("EGARCH family model long-memory setting is correctly specified", {
  expect_false(lmemo_checker(TRUE))
  expect_false(lmemo_checker(FALSE))
  expect_false(!lmemo_checker(logical(0)))
  expect_false(!lmemo_checker(c(FALSE, TRUE)))
  expect_false(!lmemo_checker(c(FALSE, TRUE, FALSE)))
})

test_that("EGARCH family model modulus setting is correctly specified", {
  expect_false(modulus_checker(c(TRUE, TRUE)))
  expect_false(modulus_checker(c(TRUE, FALSE)))
  expect_false(modulus_checker(c(FALSE, TRUE)))
  expect_false(modulus_checker(c(FALSE, FALSE)))
  expect_false(!modulus_checker(c(FALSE)))
  expect_false(!modulus_checker(logical(0)))
  expect_false(!modulus_checker(c(FALSE, TRUE, FALSE)))
})

test_that("EGARCH family model model type setting is correctly specified", {
  expect_false(model_type_checker(1))
  expect_false(model_type_checker(2))
  expect_false(!model_type_checker(0))
  expect_false(!model_type_checker(3))
  expect_false(!model_type_checker(numeric(0)))
  expect_false(!model_type_checker(c(1, 2)))
  expect_false(!model_type_checker(c(2, 1)))
  expect_false(!model_type_checker(c(1, 1)))
  expect_false(!model_type_checker(c(2, 2)))
})

test_that("EGARCH family model distribution setting is correctly specified", {
  expect_false(distr_checker("norm"))
  expect_false(distr_checker("std"))
  expect_false(distr_checker("ged"))
  expect_false(distr_checker("ald"))
  expect_false(distr_checker("snorm"))
  expect_false(distr_checker("sstd"))
  expect_false(distr_checker("sged"))
  expect_false(distr_checker("sald"))
  expect_false(!distr_checker(character(0)))
  expect_false(!distr_checker(c("norm", "std")))
  expect_false(!distr_checker(c("norm", "snorm", "ged", "ald", "sged", "std", "sstd", "sald")))
})

test_that("EGARCH family model mean setting is correctly specified", {
  expect_false(mean_checker(TRUE))
  expect_false(mean_checker(FALSE))
  expect_false(!mean_checker(logical(0)))
  expect_false(!mean_checker(c(TRUE, TRUE)))
  expect_false(!mean_checker(c(FALSE, FALSE)))
})
