% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{fm_subdivide}
\alias{fm_subdivide}
\title{Split triangles of a mesh into subtriangles}
\usage{
fm_subdivide(mesh, n = 1, delaunay = FALSE)
}
\arguments{
\item{mesh}{an \link{fm_mesh_2d} object}

\item{n}{number of added points along each edge. Default is 1.}

\item{delaunay}{logical; if \code{TRUE}, the subdivided mesh is forced into a
Delaunay triangle structure. If \code{FALSE} (default), the triangles are
subdivided uniformly instead.}
}
\value{
A refined \link{fm_mesh_2d} object, with added \code{bary} information
(an \code{\link[=fm_bary]{fm_bary()}} object), that can be used for interpolating functions from
the original mesh to the new mesh (from version \verb{0.5.0.9002}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Splits each mesh triangle into \code{(n + 1)^2} subtriangles.
The current version drops any edge constraint information from the mesh.
}
\examples{
mesh <- fm_rcdt_2d_inla(
  loc = rbind(c(0, 0), c(1, 0), c(0, 1)),
  tv = rbind(c(1, 2, 3))
)
mesh_sub <- fm_subdivide(mesh, 3)
mesh
mesh_sub

# Difference should be zero for flat triangle meshes:
sum((mesh_sub$loc - fm_basis(mesh, mesh_sub$bary) \%*\% mesh$loc)^2)

plot(mesh_sub, edge.color = 2)

plot(fm_subdivide(fmexample$mesh, 3), edge.color = 2)
plot(fmexample$mesh, add = TRUE, edge.color = 1)
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
