% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{fm_subset}
\alias{fm_subset}
\title{Extract a subset of a mesh}
\usage{
fm_subset(mesh, t_sub)
}
\arguments{
\item{mesh}{an mesh to subset}

\item{t_sub}{triangle or tetrahedron indices.}
}
\value{
A subset mesh.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} (from version \verb{0.5.0.9003})
Constructs a new mesh based on a subset of the triangles of an existing mesh.
The current version drops any edge constraint information from the mesh.
}
\examples{
mesh_sub <- fm_subset(fmexample$mesh, 1:100)
mesh_sub
plot(mesh_sub)

if (requireNamespace("geometry", quietly = TRUE)) {
  print(m <- fm_delaunay_3d(matrix(rnorm(30), 10, 3)))
  print(fm_subset(m, seq_len(min(5, nrow(m$graph$tv)))))
}
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
