% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo_dep}
\alias{geo_dep}
\title{Retrieve INSEE department codes for each feature in an sf object}
\usage{
geo_dep(x)
}
\arguments{
\item{x}{An \code{sf} object defining the area(s) of interest.}
}
\value{
A character vector with the INSEE department code corresponding
to each feature of \code{x}. Returns \code{NULL} if no intersection is found.
}
\description{
This internal helper retrieves the administrative department (\code{code_insee})
intersecting each feature of the input \code{sf} object. It uses the
\emph{Admin Express COG} WFS service from IGN via the \strong{happign} package.
}
\details{
\itemize{
\item The input is first transform to CRS:4326.
\item Centroids of the features are computed before querying the WFS service.
\item The function uses \code{\link[=quiet]{quiet()}} to suppress warnings/messages during processing.
\item If the WFS query fails or returns no features, a vector of \code{NA} values is returned.
\item The spatial join is performed using \code{\link[sf:st_join]{sf::st_join()}} with \code{st_intersects}.
}
}
\keyword{internal}
