% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip.R
\name{zip_query_build}
\alias{zip_query_build}
\title{Build a URL query to download a ZIP}
\usage{
zip_query_build(id, title, guid = NULL, extent_vals, crs = 2154)
}
\arguments{
\item{id}{\code{character} or \code{numeric}. Identifier of the dataset.}

\item{title}{\code{character}. Title of the dataset.}

\item{guid}{\code{character}, optional. GUID of the dataset, if available.}

\item{extent_vals}{\code{numeric} vector of length 4. Bounding box coordinates in
order: left, bottom, right, top.}

\item{crs}{\code{numeric}, default \code{2154}. CRS code for the coordinate reference
system to use in the query.}
}
\value{
\code{character}. URL string for downloading the dataset in ZIP format.
}
\description{
Constructs a URL query to request a ZIP file containing spatial data from
the French Ministry of Culture's "Atlas du Patrimoine" service.
}
\details{
\itemize{
\item The function formats the bounding box and metadata into a JSON object,
then encodes it into a URL suitable for the Atlas Patrimoines export service.
\item CRS is converted to a string \code{"EPSG:<code>"}.
}
}
\keyword{internal}
