% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a.R
\name{solidify}
\alias{solidify}
\title{Solidify a given fru object}
\usage{
solidify(x)
}
\arguments{
\item{x}{The fru model object.}
}
\value{
Invisibly, the same object as \code{x}, yet internally modified so that it can be serialised.
}
\description{
Forces a model to be solidified, so that it would survive through saving into RDS or sending over a network, etc.
The downside is that the forest (and/or OOB scores or importance) will exist twice in the memory, and this process takes some time.
The function converts the object in-place, thanks to the semantics of external pointers.
No-op when given an object that is already serialised, either by \code{solidify=TRUE} flag passed to \code{fru}, due to a previous call to \code{solidify} or when deserialised.
}
