% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_archive.R
\name{build_archive}
\alias{build_archive}
\title{Build a Darwin Core Archive from a folder}
\usage{
build_archive(file = "dwc-archive.zip", overwrite = FALSE, quiet = FALSE)
}
\arguments{
\item{file}{The name of the file to be built in the parent directory.
Should end in \code{.zip}.}

\item{overwrite}{(logical) Should existing files be overwritten? Defaults to
\code{FALSE}.}

\item{quiet}{(logical) Whether to suppress messages about what is happening.
Default is set to \code{FALSE}; i.e. messages are shown.}
}
\value{
Doesn't return anything; called for the side-effect of building a
'Darwin Core Archive' (i.e. a zip file).
}
\description{
A Darwin Core archive is a zip file containing a combination of
data and metadata. \code{build_archive()} constructs this zip file in the parent
directory. The function assumes that all necessary files have been
pre-constructed, and can be found inside the \code{"data-publish"} directory
with no additional or redundant information. Structurally, \code{build_archive()}
is similar to \code{devtools::build()}, in the sense that it takes a repository
and wraps it for publication.
}
\details{
This function looks for three types of objects in the \code{data-publish}
directory:
\itemize{
\item Data

One or more csv files named \code{occurrences.csv}, \code{events.csv} and/or
\code{multimedia.csv}.
These csv files contain data standardised using Darwin Core Standard
(see \code{\link[corella:corella-package]{corella::corella-package()}} for details). A \code{data.frame}/\code{tibble}
can be added to the correct folder using \code{\link[=use_data]{use_data()}}.
\item Metadata

A metadata statement in \code{EML} format with the file name \code{eml.xml}.
Completed metadata statements written markdown as \code{.Rmd} or \code{qmd} files
can be converted and saved to the correct folder using \code{\link[=use_metadata]{use_metadata()}}.
Create a new template with \code{\link[=use_metadata_template]{use_metadata_template()}}.
\item Schema

A 'schema' document in xml format with the file name \code{meta.xml}.
\code{build_archive()} will detect whether this file is present and build a
schema file if missing. This file can also be constructed
separately using \code{\link[=use_schema]{use_schema()}}.
}
}
\seealso{
\code{\link[=use_data]{use_data()}}, \code{\link[=use_metadata]{use_metadata()}}, \code{\link[=use_schema]{use_schema()}}
}
