% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-print.R
\name{summary.gctsc}
\alias{summary.gctsc}
\title{Summarize a gctsc Model Fit}
\usage{
\method{summary}{gctsc}(object, ...)
}
\arguments{
\item{object}{An object of class \code{gctsc}.}

\item{...}{Ignored. Included for S3 method compatibility.}
}
\value{
A list of class \code{"summary.gctsc"} containing:
\item{call}{The model call.}
\item{convergence}{Convergence code from the optimizer.}
\item{coefficients}{A list with two matrices: \code{marginal} and \code{copula}, each containing estimates, standard errors, z-values, and p-values.}
\item{loglik}{Approximate log-likelihood value.}
\item{aic}{Akaike Information Criterion.}
\item{bic}{Bayesian Information Criterion.}
}
\description{
Computes standard errors, z-values, and p-values for the estimated parameters
in a fitted \code{gctsc} object.
}
