% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endogenousstats.R
\name{homophily_stat}
\alias{homophily_stat}
\title{Calculate homophily in multi-edge graphs.}
\usage{
homophily_stat(
  variable = variable,
  type = "categorical",
  nodes = nodes,
  these.categories.only = NULL,
  zero_values = NULL
)
}
\arguments{
\item{variable}{A attribute variable. Can be categorical (attribute matches)
or continuous (absolute difference effects).}

\item{type}{set to \code{categorical}. Can be set to \code{absdiff} instead.
If set to \code{categorical}, the homophily statistic calculates matches
between dyads from the same group (analogous to dummy variables measuring
attribute match between two nodes (=10) and attribute mismatch (=1)). If
set to \code{absdiff} it calculates the difference in values from variable
for each dyad in the graph.}

\item{nodes}{optional character/factor vector. If an edgelist is provided, you
have to provide a list of unique identifiers of your nodes in the graph.
This is because in the edgelist, isolates are usually not recorded. If you
do not specify isolates in your nodes object, they are excluded from the
analysis (falsifies data).}

\item{these.categories.only}{optional vector specifying the categories to be
used, if only a subset of factor(variable) is needed.}

\item{zero_values}{optional numeric value. Use this to substitute zero-values
in your homophily change statistic matrix. Zero values in the predictors
are recognized in the gHypEG regression as structural zeroes. To ensure this
does not happen, please recode your zero-values in all your predictors,
ideally using a dummy variable fitting an optimal value for the zeroes.
Only useful with absdiff type.}
}
\value{
Homophily change statistic matrix.
}
\description{
The function calculates homophily matrices. If you supply a categorical
variable (factor, character), the function returns attribute matches for
dyads from the same group. If you supply a continuous variable (numeric,
integers), the function returns absolute difference effects for each dyad in
the graph.
}
\examples{
homop_stat <- homophily_stat(variable = vertexlabels, nodes = rownames(adj_karate))
nrm(w=list('homophily'= homop_stat), adj_karate, directed = FALSE, selfloops = FALSE)
}
\seealso{
\code{\link{reciprocity_stat}} or \code{\link{sharedPartner_stat}}
}
\author{
LB, GC
}
