% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariates.R
\name{SpatialConstant}
\alias{SpatialConstant}
\title{Creates a spatial constant covariate}
\usage{
SpatialConstant(x)
}
\arguments{
\item{x}{(numeric vector) covariate values for each time-point. Values are used for each location.}
}
\value{
The input numeric vector with an additional attribute \code{const} set to \code{"space"}.
}
\description{
This function assigns a \code{const} attribute set to \code{"space"} to a numeric vector.
}
\details{
A spatial-constant covariate has the form \deqn{\mathbf{x}_t = x_t \mathbf{1}_p,} i.e., it has the same value \eqn{x_t} for all locations at time-point \eqn{t}.
}
\seealso{
\link{TimeConstant}
}
