% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_glmstarma.R
\name{residuals.glmstarma}
\alias{residuals.glmstarma}
\alias{residuals.dglmstarma}
\title{Residuals for glmstarma and dglmstarma Models}
\usage{
\method{residuals}{glmstarma}(
  object,
  type = c("response", "pearson", "deviance"),
  drop_init = TRUE,
  ignore_dispersion = TRUE
)

\method{residuals}{dglmstarma}(
  object,
  type = c("response", "pearson", "deviance"),
  drop_init = TRUE,
  ignore_dispersion = TRUE
)
}
\arguments{
\item{object}{A fitted \code{glmstarma} or \code{dglmstarma} object.}

\item{type}{Type of residuals to compute. Options are \code{"response"} (raw residuals), \code{"pearson"}. See details.}

\item{drop_init}{Logical; if \code{TRUE}, initial first \code{max_time_lag} columns of residuals are dropped.}

\item{ignore_dispersion}{Logical; if \code{TRUE}, values are not scaled by the dispersion parameter}
}
\value{
A matrix of residuals.
}
\description{
Compute residuals for fitted \code{glmstarma} and \code{dglmstarma} models.
}
\details{
The \code{type} argument specifies the type of residuals to compute:
\itemize{
\item \code{"response"}: Raw residuals, computed as the difference between observed and fitted values.
\item \code{"pearson"}: Pearson residuals, defined as \deqn{r_i = \frac{y_i - \mu_i}{\sqrt{V(\mu_i)}}}, where \eqn{V(\mu_i)} is the variance function of the specified family.
\item \code{"deviance"}: Deviance residuals, defined as \deqn{r_i = 2 \cdot (\ell(y_i; y_i) - \ell(y_i; \mu_i)),} i.e. the log-likelihood difference of a saturated model and the fitted model.
If \code{ignore_dispersion} is set to \code{FALSE}, pearson and deviance residuals are scaled by the dispersion parameter(s).
}
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary

model_autoregressive <- list(past_obs = rep(1, 7))
fit <- glmstarma(chickenpox, model_autoregressive, W_hungary, family = vpoisson("log"),
                 covariates = list(population = population_hungary))
residuals(fit)

mean_model <- list(past_obs = rep(1, 7))
dispersion_model <- list(past_obs = 1)
fit2 <- dglmstarma(chickenpox, mean_model, dispersion_model, mean_family = vquasipoisson("log"),
                   dispersion_link = "log",
                   wlist = W_hungary, 
                   mean_covariates = list(population = population_hungary))
residuals(fit2)
}
}
