% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natural-language.R
\name{gl_nlp}
\alias{gl_nlp}
\title{Perform Natural Language Analysis}
\usage{
gl_nlp(
  string,
  nlp_type = c("annotateText", "analyzeEntities", "analyzeSentiment", "analyzeSyntax",
    "analyzeEntitySentiment", "classifyText"),
  type = c("PLAIN_TEXT", "HTML"),
  language = c("en", "zh", "zh-Hant", "fr", "de", "it", "ja", "ko", "pt", "es"),
  encodingType = c("UTF8", "UTF16", "UTF32", "NONE")
)
}
\arguments{
\item{string}{Character vector. Text to analyse or Google Cloud Storage URI(s) in the form \code{gs://bucket_name/object_name}.}

\item{nlp_type}{Character. Type of analysis to perform. Default \code{annotateText} performs all features in a single call. Options include: \code{analyzeEntities}, \code{analyzeSentiment}, \code{analyzeSyntax}, \code{analyzeEntitySentiment}, \code{classifyText}.}

\item{type}{Character. Whether the input is plain text (\code{PLAIN_TEXT}) or HTML (\code{HTML}).}

\item{language}{Character. Language of the source text. Must be supported by the API.}

\item{encodingType}{Character. Text encoding used to process the output. Default \code{UTF8}.}
}
\value{
A list containing the requested components as specified by \code{nlp_type}:
\item{sentences}{Sentences in the input document. \href{https://cloud.google.com/natural-language/docs/reference/rest/v1/Sentence}{API reference.}}
\item{tokens}{Tokens with syntactic information. \href{https://cloud.google.com/natural-language/docs/reference/rest/v1/Token}{API reference.}}
\item{entities}{Entities with semantic information. \href{https://cloud.google.com/natural-language/docs/reference/rest/v1/Entity}{API reference.}}
\item{documentSentiment}{Overall sentiment of the document. \href{https://cloud.google.com/natural-language/docs/reference/rest/v1/Sentiment}{API reference.}}
\item{classifyText}{Document classification. \href{https://cloud.google.com/natural-language/docs/classifying-text}{API reference.}}
\item{language}{Detected language of the text, or the language specified in the request.}
\item{text}{Original text passed to the API. Returns \code{NA} if input is empty.}
}
\description{
Analyse text for entities, sentiment, syntax and classification using the Google Natural Language API.
}
\details{
Encoding type can usually be left at the default \code{UTF8}.
\href{https://cloud.google.com/natural-language/docs/reference/rest/v1/EncodingType}{Further details on encoding types.}

Current language support is listed \href{https://cloud.google.com/natural-language/docs/languages}{here}.
}
\examples{
\dontrun{
library(googleLanguageR)

text <- "To administer medicine to animals is frequently difficult, yet sometimes necessary."
nlp <- gl_nlp(text)

nlp$sentences
nlp$tokens
nlp$entities
nlp$documentSentiment

# Vectorised input
texts <- c("The cat sat on the mat.", "Oh no, it did not, you fool!")
nlp_results <- gl_nlp(texts)
}

}
\seealso{
\url{https://cloud.google.com/natural-language/docs/reference/rest/v1/documents}
}
