% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls.r
\name{h5_ls}
\alias{h5_ls}
\title{List HDF5 Objects}
\usage{
h5_ls(file, name = "/", recursive = TRUE, full.names = FALSE, scales = FALSE)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The group path to start listing from. Defaults to the root group (\code{/}).}

\item{recursive}{If \code{TRUE} (default), lists all objects found recursively
under \code{name}. If \code{FALSE}, lists only the immediate children.}

\item{full.names}{If \code{TRUE}, the full paths from the file's root are
returned. If \code{FALSE} (the default), names are relative to \code{name}.}

\item{scales}{If \code{TRUE}, also returns datasets that are dimensions scales for
other datasets.}
}
\value{
A character vector of object names. If \code{name} is \code{/} (the default),
the paths are relative to the root of the file. If \code{name} is another group,
the paths are relative to that group (unless \code{full.names = TRUE}).
}
\description{
Lists the names of objects (datasets and groups) within an HDF5 file or group.
}
\examples{
file <- tempfile(fileext = ".h5")
h5_create_group(file, "foo/bar")
h5_write(1:5, file, "foo/data")

# List everything recursively
h5_ls(file)

# List only top-level objects
h5_ls(file, recursive = FALSE)

# List relative to a sub-group
h5_ls(file, "foo")

unlink(file)
}
\seealso{
\code{\link[=h5_attr_names]{h5_attr_names()}}, \code{\link[=h5_str]{h5_str()}}
}
