% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_stats.R
\name{dg_closest_res_to_area}
\alias{dg_closest_res_to_area}
\title{Find closest resolution for target cell area}
\usage{
dg_closest_res_to_area(
  dggs,
  area,
  round = "nearest",
  metric = TRUE,
  show_info = FALSE
)
}
\arguments{
\item{dggs}{Grid specification (aperture and topology must be set)}

\item{area}{Target cell area in km^2 (if metric=TRUE)}

\item{round}{Rounding method ("nearest", "up", "down")}

\item{metric}{Whether area is in metric units}

\item{show_info}{Print information about chosen resolution}
}
\value{
Resolution level (integer)
}
\description{
Finds the grid resolution that produces cells closest to the target area.
This is primarily used internally by \code{\link{hexify_grid}} and
\code{\link{hex_grid}}. Most users should use those functions directly.
}
\examples{
# Create a temporary grid to get aperture settings
temp_grid <- list(aperture = 3, topology = "HEXAGON")
class(temp_grid) <- "hexify_grid"

# Find resolution for 1000 km^2 cells
res <- dg_closest_res_to_area(temp_grid, area = 1000, 
                               metric = TRUE, show_info = TRUE)
print(res)
}
\seealso{
Other grid statistics: 
\code{\link{dgearthstat}()},
\code{\link{hexify_area_to_eff_res}()},
\code{\link{hexify_compare_resolutions}()},
\code{\link{hexify_eff_res_to_area}()},
\code{\link{hexify_eff_res_to_resolution}()},
\code{\link{hexify_resolution_to_eff_res}()}
}
\concept{grid statistics}
\keyword{internal}
