% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastplot.R
\name{predict.inz_ts}
\alias{predict.inz_ts}
\alias{plot.inz_frct}
\title{Forecast future observations}
\usage{
\method{predict}{inz_ts}(
  object,
  var = NULL,
  h = 8,
  mult_fit = FALSE,
  pred_model = "auto",
  confint_width = 0.95,
  model_range = NULL,
  ...
)

\method{plot}{inz_frct}(x, t_range = NULL, xlab = NULL, ylab = NULL, title = NULL, ...)
}
\arguments{
\item{object}{An \code{inzightts} object representing the time series.}

\item{var}{A character vector specifying the variable(s) to forecast, or set
to \code{NULL} to forecast all variables.}

\item{h}{The forecast horizon, either the number of observations to predict,
or a character string specifying the time interval to predict
(e.g., \code{"2 years"}).}

\item{mult_fit}{Logical; set to \code{TRUE} for a multiplicative model, or
\code{FALSE} for the default additive model.}

\item{pred_model}{The name of a \code{fable} model function or \code{"auto"}.}

\item{confint_width}{A decimal representing the width of the prediction
interval.}

\item{model_range}{The range of data to be used for fitting forecasts,
specified as dates or years.}

\item{...}{Additional arguments (ignored).}

\item{x}{An \code{inz_frct} object containing the forecasts.}

\item{t_range}{The range of data to be plotted, specified as dates or years.}

\item{xlab}{A title for the x-axis of the plot.}

\item{ylab}{A title for the y-axis of the plot.}

\item{title}{A title for the graph.}
}
\value{
An \code{inz_frct} object containing the forecasts.
}
\description{
Generates future predictions of the time series from an \code{inzightts} object.
The output object includes predicted means, prediction intervals, raw data,
and fitted values.
}
\examples{
t <- inzightts(visitorsQ, var = c(2, 4))
## The following two examples are equivalent
pred <- predict(t, names(t)[-1], h = "2 years")
pred <- predict(t, names(t)[-1], h = 8)

\dontrun{
plot(pred)
}

}
\seealso{
\code{\link[fable]{fable-package}}
}
