% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igfetchr.R
\name{ig_execute_trade}
\alias{ig_execute_trade}
\title{Execute a trade (place OTC position)}
\usage{
ig_execute_trade(
  epic,
  direction,
  size,
  auth,
  currency_code = NULL,
  expiry = NULL,
  guaranteed_stop = FALSE,
  level = NULL,
  time_in_force = "FILL_OR_KILL",
  order_type = "MARKET",
  limit_distance = NULL,
  limit_level = NULL,
  stop_distance = NULL,
  stop_level = NULL,
  deal_reference = NULL,
  force_open = NULL,
  mock_response = NULL
)
}
\arguments{
\item{epic}{Character. Market epic (e.g., "CS.D.USDCHF.MINI.IP").}

\item{direction}{Character. "BUY" or "SELL".}

\item{size}{Numeric. Trade size (units).}

\item{auth}{List. Authentication details from \code{\link{ig_auth}}.}

\item{currency_code}{Character. Currency code (e.g., "CHF"). Defaults to NULL.}

\item{expiry}{Character. Expiry date (e.g., "-"). Defaults to NULL.}

\item{guaranteed_stop}{Logical. Use guaranteed stop. Defaults to FALSE.}

\item{level}{Numeric. Price level for LIMIT orders. Defaults to NULL.}

\item{time_in_force}{Character. "EXECUTE_AND_ELIMINATE" or "FILL_OR_KILL". Defaults to "FILL_OR_KILL".}

\item{order_type}{Character. "MARKET" or "LIMIT". Defaults to "MARKET".}

\item{limit_distance}{Numeric. Limit distance in points. Defaults to NULL.}

\item{limit_level}{Numeric. Limit price. Defaults to NULL.}

\item{stop_distance}{Numeric. Stop distance in points. Defaults to NULL.}

\item{stop_level}{Numeric. Stop price. Defaults to NULL.}

\item{deal_reference}{Character. Custom deal reference. Defaults to NULL.}

\item{force_open}{Logical. Force new position. Defaults to TRUE if stops/limits specified.}

\item{mock_response}{List or data frame. Mock response for testing.}
}
\value{
A tibble with trade confirmation details including deal ID and deal reference.
}
\description{
Places a market trade using the IG API.
If stops/limits fail, falls back to placing the trade without them and adding via PUT.
}
\examples{
\dontrun{
auth <- ig_auth(
username = "your_username",
password = "your_password",
api_key = "your_api_key",
acc_type = "DEMO",
acc_number = "ABC123")
res <- ig_execute_trade(
  epic = "CS.D.USDCHF.MINI.IP",
  direction = "BUY",
  size = 1.0,
  auth = auth,
  currency_code = "CHF",
  order_type = "MARKET",
  time_in_force = "FILL_OR_KILL",
  limit_distance = 2000,
  stop_distance = 2000,
  guaranteed_stop = FALSE,
  force_open = TRUE
)
print(res)
}

}
