% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_vis.R
\name{vis.immunr_inc_overlap}
\alias{vis.immunr_inc_overlap}
\title{Visualise incremental overlaps}
\usage{
\method{vis}{immunr_inc_overlap}(.data, .target = 1, .grid = FALSE, .ncol = 2, ...)
}
\arguments{
\item{.data}{Output from the \link{repOverlap} function that uses "top" methods.}

\item{.target}{Index of a repertoire to plot. Omitted if .grid is TRUE.}

\item{.grid}{Logical. If TRUE then plot all similarities in a grid.}

\item{.ncol}{Numeric. Number of columns in the resulting grid.}

\item{...}{Not used here.}
}
\value{
A ggplot2 object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
\dontrun{
data(immdata)
tmp <- repOverlap(immdata$data[1:4], "inc+overlap", .verbose.inc = FALSE, .verbose = FALSE)
vis(tmp, .target = 1)
vis(tmp, .grid = TRUE)
}
}
\seealso{
\link{repOverlap}
}
\concept{overlap}
