% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filtering.R
\name{Filtering}
\alias{Filtering}
\title{Filtering}
\usage{
Filtering(
  Nodes,
  X,
  UploadPath,
  DownloadPath,
  qualityType,
  minLen,
  trim,
  trimValue,
  n,
  Adapters,
  Lpattern,
  Rpattern,
  max.Lmismatch,
  max.Rmismatch,
  kW,
  left,
  right,
  halfwidthAnalysis,
  halfwidth,
  compress
)
}
\arguments{
\item{Nodes}{Integer. Number of parallel processing nodes (e.g., CPU cores).}

\item{X}{List of character vectors. Each element is a character vector of paired file names (e.g., c("sample_1.fq", "sample_2.fq")).}

\item{UploadPath}{Character. Path to directory containing raw FASTQ files.}

\item{DownloadPath}{Character. Path to directory where filtered files will be saved.}

\item{qualityType}{Character. Type of quality score encoding, e.g., "Sanger" or "Illumina".}

\item{minLen}{Integer. Minimum length of reads to retain after filtering.}

\item{trim}{Logical. Whether to perform quality-based trimming of reads.}

\item{trimValue}{Integer. Minimum Phred score threshold for trimming.}

\item{n}{Integer. Number of reads to stream per chunk (default typically set to 1e6).}

\item{Adapters}{Logical. Whether to remove adapters from reads.}

\item{Lpattern}{Character. Adapter sequence to remove from the 5' end (left).}

\item{Rpattern}{Character. Adapter sequence to remove from the 3' end (right).}

\item{max.Lmismatch}{Integer. Maximum mismatches allowed for the left adapter.}

\item{max.Rmismatch}{Integer. Maximum mismatches allowed for the right adapter.}

\item{kW}{Integer. Minimum number of low-quality scores in a window to trigger trimming (sliding window analysis).}

\item{left}{Logical. Whether to allow trimming from the left end.}

\item{right}{Logical. Whether to allow trimming from the right end.}

\item{halfwidthAnalysis}{Logical. Whether to perform sliding window-based trimming.}

\item{halfwidth}{Integer. Half-width of the sliding window.}

\item{compress}{Logical. Whether to compress the output FASTQ files.}
}
\value{
Filtered FASTQ files written to "DownloadPath"; one log file per sample.
}
\description{
Filter paired-end FASTQ files in parallel based on quality and adapter trimming criteria.
}
\details{
This function processes raw paired-end FASTQ files to remove low-quality bases, trim adapters,
and filter out short reads. It supports quality-based end trimming, sliding window trimming,
and adapter removal. The processing is done in parallel across multiple nodes to enhance performance
when working with large datasets.
\itemize{
\item Paired FASTQ files must be named consistently, distinguished by "_1" and "_2" for forward and reverse reads.
\item This function uses the "ShortRead" and "Biostrings" packages for FASTQ processing and quality filtering.
\item Filtered files in FASTQ format".
\item Log files containing read counts before and after filtering are written per sample.
}
}
