% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset_config.R
\name{inset_spec}
\alias{inset_spec}
\title{Create a plot specification for insets}
\usage{
inset_spec(
  xmin = NA,
  xmax = NA,
  ymin = NA,
  ymax = NA,
  loc = "right bottom",
  loc_left = NA,
  loc_bottom = NA,
  width = NA,
  height = NA,
  scale_factor = NA,
  main = FALSE,
  plot = NULL
)
}
\arguments{
\item{xmin, xmax, ymin, ymax}{Numeric bbox coordinates for the subplot in the
coordinate system of the data, normally longitude/latitude. Any may
be NA and will be inferred from the overall extent if possible.}

\item{loc}{A convenience string like "left bottom", "center top", etc. to specify
the position of the inset on the full canvas. Horizontal position must be one of
"left", "center", or "right"; vertical position must be one of "bottom", "center", or "top".
Ignored when \code{loc_left} and \code{loc_bottom} are provided.}

\item{loc_left, loc_bottom}{Numbers in [0, 1] for the bottom-left position of
the inset on the full canvas.}

\item{width, height}{Numeric values in (0, 1] for the size of the inset.
It is recommended to provide only one of these; the other dimension will be
inferred to maintain the aspect ratio of the spatial extent. It is also
recommended to use \code{scale_factor} to automatically size the inset relative to
the main plot instead of specifying width/height directly.}

\item{scale_factor}{Numeric value in (0, Inf) indicating the scale of the inset
relative to the main plot. If not NA, the inset's width/height are
automatically derived from the spatial ranges relative to the main plot
multiplied by this factor. For example, the scale of the main plot is 1:10,000,
the inset's dimensions will be 1:20,000 if \code{scale_factor} is 0.5.}

\item{main}{Logical. TRUE marks this spec as the main plot (exactly one).
Default FALSE.}

\item{plot}{Optional ggplot object to use for this spec instead of the base
plot passed to \code{\link[=with_inset]{with_inset()}}.}
}
\value{
A list with elements \code{bbox}, \code{loc_left}, \code{loc_bottom}, \code{width},
\code{height}, \code{scale_factor}, \code{main}, \code{plot}, \code{hpos}, and \code{vpos}. You do not
normally need to interact with this object directly; it is used internally.
}
\description{
Define the spatial extent and positioning for each subplot (main or inset).
}
\examples{
specs <- list(
    # Create a main plot specification
    inset_spec(main = TRUE),
    # Create an inset plot specification with explicit dimensions
    inset_spec(
        xmin = -120, xmax = -100, ymin = 30, ymax = 50,
        loc = "right bottom",
        width = 0.3
    ),
    # Create an inset with scale factor
    inset_spec(
        xmin = -120, xmax = -100, ymin = 30, ymax = 50,
        loc = "left bottom",
        scale_factor = 0.5
    )
)

}
