% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_call.R
\name{get_call}
\alias{get_call}
\title{Get the model's function call}
\usage{
get_call(x)
}
\arguments{
\item{x}{A fitted mixed model.}
}
\value{
A function call.
}
\description{
Returns the model's function call when available.
}
\examples{
\dontshow{if (require("lme4", quietly = TRUE)) withAutoprint(\{ # examplesIf}
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_call(m)

m <- lme4::lmer(Sepal.Length ~ Sepal.Width + (1 | Species), data = iris)
get_call(m)
\dontshow{\}) # examplesIf}
}
