% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{pvisgam}
\alias{pvisgam}
\title{Visualization of partial nonlinear interactions.}
\usage{
pvisgam(
  x,
  view = NULL,
  select = NULL,
  cond = list(),
  n.grid = 30,
  too.far = 0,
  col = NA,
  color = "terrain",
  contour.col = NULL,
  add.color.legend = TRUE,
  se = 0,
  plot.type = "contour",
  zlim = NULL,
  xlim = NULL,
  ylim = NULL,
  nCol = 50,
  labcex = 0.6,
  hide.label = FALSE,
  print.summary = getOption("itsadug_print"),
  show.diff = FALSE,
  col.diff = 1,
  alpha.diff = 0.5,
  dec = NULL,
  f = 1.96,
  ...
)
}
\arguments{
\item{x}{A gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}.}

\item{view}{A two-value vector containing the names of the two main effect 
terms to be displayed on the x and y dimensions of the plot. Note that 
variables coerced to factors in the model formula won't work as view 
variables.}

\item{select}{A number, selecting a single model term for printing. e.g. 
if you want the plot for the second smooth term set select=2.}

\item{cond}{A named list of the values to use for the other predictor terms 
(not in view). Used for choosing between smooths that share the same view 
predictors.}

\item{n.grid}{The number of grid nodes in each direction used for 
calculating the plotted surface.}

\item{too.far}{Plot grid nodes that are too far from the points defined by 
the variables given in view can be excluded from the plot. too.far 
determines what is too far. The grid is scaled into the unit square along 
with the view variables and then grid nodes more than too.far from the 
predictor variables are excluded.}

\item{col}{The colors for the facets of the plot.}

\item{color}{The color scheme to use for plots. One of 'topo', 'heat', 
'cm', 'terrain', 'gray' or 'bw'. Alternatively a vector with some colors 
can be provided for a custom color palette (see examples).}

\item{contour.col}{sets the color of contours when using plot.}

\item{add.color.legend}{Logical: whether or not to add a color legend. 
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link[plotfunctions]{gradientLegend}} to add a legend manually at any position.}

\item{se}{If less than or equal to zero then only the predicted surface is 
plotted, but if greater than zero, then 3 surfaces are plotted, one at the 
predicted values minus se standard errors, one at the predicted values and 
one at the predicted values plus se standard errors.}

\item{plot.type}{one of 'contour' or 'persp' (default is 'contour').}

\item{zlim}{A two item array giving the lower and upper limits for the z-
axis scale. NULL to choose automatically.}

\item{xlim}{A two item array giving the lower and upper limits for the x-
axis scale. NULL to choose automatically.}

\item{ylim}{A two item array giving the lower and upper limits for the y-
axis scale. NULL to choose automatically.}

\item{nCol}{The number of colors to use in color schemes.}

\item{labcex}{Size of the contour labels.}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., 'partial effect'). Default is FALSE.}

\item{print.summary}{Logical: whether or not to print summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{show.diff}{Logical: whether or not to indicate the regions that 
are significantly different from zero. Note that these regions are just 
an indication and dependent on the value of \code{n.grid}. 
Defaults to FALSE.}

\item{col.diff}{Color to shade the nonsignificant areas.}

\item{alpha.diff}{Level of transparency to mark the nonsignificant areas.}

\item{dec}{Numeric: number of decimals for rounding the color legend. 
When NULL (default), no rounding.}

\item{f}{Scaling factor to determine the CI from the se, for marking the 
difference with 0. Only applies when \code{se} is smaller or equal to zero 
and \code{show.diff} is set to TRUE.}

\item{...}{other options to pass on to persp, image or contour. In 
particular ticktype='detailed' will add proper axes labeling to the plots.}
}
\description{
Produces perspective or contour plot views of gam model 
predictions of the partial effects interactions. Combines the function 
\code{\link[mgcv]{plot.gam}} for interaction surfaces with the function 
\code{\link[mgcv]{vis.gam}}. Similar to \code{\link[mgcv]{plot.gam}}, 
\code{pvisgam} plots the partial interaction surface, without including 
values for other predictors that are not being shown. Similar to 
\code{\link[mgcv]{vis.gam}} the user can set the two predictors to be 
viewed, and colors are added behind the contours to facilitate 
interpretation. In contrast to \code{\link[mgcv]{plot.gam}}, this function 
allows to plotting of interactions with three of more continuous predictors 
by breaking it down in two-dimensional surfaces.
The code is derivated from the script for \code{\link[mgcv]{vis.gam}}.
}
\section{Warnings}{

\itemize{
\item In contrast to vis.gam, do not specify other predictors in \code{cond} that 
are not to be plotted.
\item When the argument \code{show.diff} is set to TRUE a shading area indicates 
where the confidence intervals include zero. Or, in other words, the areas 
that are not significantly different from zero. Be careful with the 
interpretation, however, as the precise shape of the surface is dependent 
on model constraints such as the value of \code{\link[mgcv]{choose.k}} and the 
smooth function used, and the size of the confidence intervals are 
dependent on the model fit and model characteristics 
(see \code{vignette('acf', package='itsadug')}). In addition, the value of 
\code{n.grid} determines the precision of the plot.
}
}

\examples{
data(simdat)

\dontrun{
# Model with random effect and interactions:
m1 <- bam(Y ~ te(Time, Trial)+s(Time, Subject, bs='fs', m=1),
    data=simdat, discrete=TRUE)

# Plot summed effects:
vis.gam(m1, view=c('Time', 'Trial'), plot.type='contour', color='topo')
# Partial effect of interaction:
pvisgam(m1, view=c('Time', 'Trial'), select=1)
# Same:
plot(m1, select=1, scheme=2)
plot(m1, select=1)
# Alternatives:
pvisgam(m1, view=c('Trial', 'Time'), select=1)
pvisgam(m1, view=c('Trial', 'Time'), select=1, zlim=c(-20,20))
pvisgam(m1, view=c('Trial', 'Time'), select=1, zlim=c(-20,20), 
    color='terrain')
pvisgam(m1, view=c('Trial', 'Time'), select=1, zlim=c(-20,20), 
    color=c('blue', 'white', 'red'))

# Notes on the color legend:
# Labels can easily fall off the plot, therefore the numbers are 
# automatically rounded.
# To undo the rounding, set dec=NULL:
pvisgam(m1, view=c('Time', 'Trial'), dec=NULL)
# For custom rounding, set dec to a value:
pvisgam(m1, view=c('Time', 'Trial'), dec=1)
# To increase the left marging of the plot (so that the numbers fit):
oldmar <- par()$mar
par(mar=oldmar + c(0,0,0,1) ) # add one line to the right
pvisgam(m1, view=c('Time', 'Trial'), dec=3)
par(mar=oldmar) # restore to default settings

# too.far: 
n <- which(simdat$Time > 1500 & simdat$Trial > 5)
simdat[n,]$Y <- NA
simdat[simdat$Trial == -3,]$Y <- NA
m1 <- bam(Y ~ te(Time, Trial)+s(Time, Subject, bs='fs', m=1),
    data=simdat, discrete=TRUE)
pvisgam(m1, view=c('Time', 'Trial'), select=1, too.far=0.03)

}
# see the vignette for examples:
vignette('overview', package='itsadug')
}
\seealso{
\code{\link[mgcv]{vis.gam}}, \code{\link[mgcv]{plot.gam}}

Other Functions for model inspection: 
\code{\link{dispersion}()},
\code{\link{fvisgam}()},
\code{\link{gamtabs}()},
\code{\link{inspect_random}()},
\code{\link{plot_data}()},
\code{\link{plot_parametric}()},
\code{\link{plot_smooth}()},
\code{\link{plot_topo}()}
}
\author{
Jacolien van Rij. Modification of \code{\link[mgcv]{vis.gam}} from 
package \code{\link[mgcv]{mgcv}} of Simon N. Wood.
}
\concept{Functions for model inspection}
