% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.R
\name{jaccard}
\alias{jaccard}
\title{Compute a Jaccard/Tanimoto similarity coefficient}
\usage{
jaccard(x, y, center = FALSE, px = NULL, py = NULL)
}
\arguments{
\item{x}{a binary vector (e.g., fingerprint)}

\item{y}{a binary vector (e.g., fingerprint)}

\item{center}{whether to center the Jaccard/Tanimoto coefficient by its expectation}

\item{px}{probability of successes in \code{x} (optional)}

\item{py}{probability of successes in \code{y} (optional)}
}
\value{
\code{jaccard.test.bootstrap} returns an expected value.
}
\description{
Compute a Jaccard/Tanimoto similarity coefficient
}
\examples{
set.seed(1234)
x = rbinom(100,1,.5)
y = rbinom(100,1,.5)
jaccard(x,y)
}
