% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_spy.R
\name{join_spy}
\alias{join_spy}
\title{Comprehensive Pre-Join Diagnostic Report}
\usage{
join_spy(x, y, by, sample = NULL, ...)
}
\arguments{
\item{x}{A data frame (left table in the join).}

\item{y}{A data frame (right table in the join).}

\item{by}{A character vector of column names to join by, or a named character
vector for joins where column names differ (e.g., \code{c("id" = "customer_id")}).}

\item{sample}{Integer or NULL. If provided, randomly sample this many rows
from each table for faster diagnostics on large datasets. Default NULL
(analyze all rows).}

\item{...}{Reserved for future use.}
}
\value{
A \code{JoinReport} object with the following components:
\describe{
\item{x_summary}{Summary statistics for keys in the left table}
\item{y_summary}{Summary statistics for keys in the right table}
\item{match_analysis}{Details of which keys will/won't match}
\item{issues}{List of detected problems (duplicates, whitespace, etc.)}
\item{expected_rows}{Predicted row counts for each join type}
}
}
\description{
Analyzes two data frames before joining to detect potential issues and
predict the outcome. Returns a detailed report of key quality, match rates,
and detected problems.
}
\details{
This function detects the following common join issues:
\itemize{
\item \strong{Duplicate keys}: Keys appearing multiple times, which cause
row multiplication during joins
\item \strong{Whitespace}: Leading or trailing spaces that prevent matches
\item \strong{Case mismatches}: Keys that differ only by case (e.g., "ABC" vs "abc")
\item \strong{Encoding issues}: Different character encodings or invisible
Unicode characters
\item \strong{NA values}: Missing values in key columns
}
}
\examples{
# Create sample data with issues
orders <- data.frame(
  order_id = 1:5,
  customer_id = c("A", "B", "B", "C", "D ")
)
customers <- data.frame(
  customer_id = c("A", "B", "C", "E"),
  name = c("Alice", "Bob", "Carol", "Eve")
)

# Get diagnostic report
join_spy(orders, customers, by = "customer_id")

}
\seealso{
\code{\link[=key_check]{key_check()}}, \code{\link[=join_explain]{join_explain()}}, \code{\link[=join_strict]{join_strict()}}
}
