% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_softmax}
\alias{activation_softmax}
\title{Softmax converts a vector of values to a probability distribution.}
\usage{
activation_softmax(x, axis = -1L)
}
\arguments{
\item{x}{Input tensor.}

\item{axis}{Integer, axis along which the softmax is applied.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
The elements of the output vector are in range \verb{[0, 1]} and sum to 1.

Each input vector is handled independently.
The \code{axis} argument sets which axis of the input the function
is applied along.

Softmax is often used as the activation for the last
layer of a classification network because the result could be interpreted as
a probability distribution.

The softmax of each vector x is computed as
\code{exp(x) / sum(exp(x))}.

The input values in are the log-odds of the resulting probability.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/layers/activations#softmax-function}
}

Other activations: \cr
\code{\link{activation_celu}()} \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_glu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_sparse_sigmoid}()} \cr
\code{\link{activation_sparsemax}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
\code{\link{activation_threshold}()} \cr
}
\concept{activations}
