% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{dataset_boston_housing}
\alias{dataset_boston_housing}
\title{Boston housing price regression dataset}
\usage{
dataset_boston_housing(
  path = "boston_housing.npz",
  test_split = 0.2,
  seed = 113L,
  convert = TRUE
)
}
\arguments{
\item{path}{Path where to cache the dataset locally (relative to
~/.keras/datasets).}

\item{test_split}{fraction of the data to reserve as test set.}

\item{seed}{Random seed for shuffling the data before computing the test
split.}

\item{convert}{When \code{TRUE} (default) the datasets are returned as R arrays.
If \code{FALSE}, objects are returned as NumPy arrays.}
}
\value{
Lists of training and test data: \verb{train$x, train$y, test$x, test$y}.

Samples contain 13 attributes of houses at different locations around
the Boston suburbs in the late 1970s. Targets are the median values of the
houses at a location (in k$).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{str(dataset_boston_housing())
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## List of 2
##  $ train:List of 2
##   ..$ x: num [1:404, 1:13] 1.2325 0.0218 4.8982 0.0396 3.6931 ...
##   ..$ y: num [1:404(1d)] 15.2 42.3 50 21.1 17.7 18.5 11.3 15.6 15.6 14.4 ...
##  $ test :List of 2
##   ..$ x: num [1:102, 1:13] 18.0846 0.1233 0.055 1.2735 0.0715 ...
##   ..$ y: num [1:102(1d)] 7.2 18.8 19 27 22.2 24.5 31.2 22.9 20.5 23.2 ...

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{str(dataset_boston_housing(convert = FALSE))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## List of 2
##  $ train:List of 2
##   ..$ x: <numpy.ndarray shape(404,13), dtype=float64>
##   ..$ y: <numpy.ndarray shape(404), dtype=float64>
##  $ test :List of 2
##   ..$ x: <numpy.ndarray shape(102,13), dtype=float64>
##   ..$ y: <numpy.ndarray shape(102), dtype=float64>

}\if{html}{\out{</div>}}
}
\description{
Dataset taken from the StatLib library which is maintained at Carnegie Mellon
University.
}
\seealso{
Other datasets: \cr
\code{\link{dataset_california_housing}()} \cr
\code{\link{dataset_cifar10}()} \cr
\code{\link{dataset_cifar100}()} \cr
\code{\link{dataset_fashion_mnist}()} \cr
\code{\link{dataset_imdb}()} \cr
\code{\link{dataset_mnist}()} \cr
\code{\link{dataset_reuters}()} \cr
}
\concept{datasets}
