% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid_qq.R
\name{resid_qq}
\alias{resid_qq}
\title{Q-Q plot of residual correlation z-statistics}
\usage{
resid_qq(fit, n = 5, title = NULL)
}
\arguments{
\item{fit}{A fitted \code{lavaan} object.}

\item{n}{Number of most extreme |z| points to label (per group). Default 5.}

\item{title}{Optional plot title.}
}
\value{
A \code{ggplot2} object.
}
\description{
Draws a Q-Q plot for residual correlation z-statistics returned by
\code{resid_cor()}. For multi-group models, a separate panel is drawn for
each group. The \code{n} most extreme pairs (by |z|) are labeled.
}
\details{
The z-statistics are expected to follow approximately a standard normal
distribution N(0, 1) under correct model specification, so systematic
deflections from the diagonal in the Q-Q plot indicate potential model
misfit or localized residual dependencies.

If \code{z} is not available from \code{lavaan::lavResiduals()}, the
function attempts to compute it as \code{cor / se}. If neither \code{z}
nor \code{se} are available, the function stops with an informative error.
}
\examples{
# Single-group example
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
fit <- lavaan::cfa(HS.model, data = lavaan::HolzingerSwineford1939)
resid_qq(fit, n = 5)

# Multi-group example (groups by "school")
fit_mg <- lavaan::cfa(HS.model,
                      data  = lavaan::HolzingerSwineford1939,
                      group = "school")
resid_qq(fit_mg, n = 7, title = "Residual z Q-Q by group")

}
\seealso{
\code{\link{resid_cor}}, \code{\link{resid_corrplot}}, \code{\link{hopper_plot}}
}
