% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzchar_linter.R
\name{nzchar_linter}
\alias{nzchar_linter}
\title{Require usage of nzchar where appropriate}
\usage{
nzchar_linter()
}
\description{
\code{\link[=nzchar]{nzchar()}} efficiently determines which of a vector of strings are empty
(i.e., are \code{""}). It should in most cases be used instead of
constructions like \code{string == ""} or \code{nchar(string) == 0}.
}
\details{
One crucial difference is in the default handling of \code{NA_character_}, i.e.,
missing strings. \code{nzchar(NA_character_)} is \code{TRUE}, while \code{NA_character_ == ""}
and \code{nchar(NA_character_) == 0} are both \code{NA}. Therefore, for strict
compatibility, use \code{nzchar(x, keepNA = TRUE)}. If the input is known to be
complete (no missing entries), this argument can be dropped for conciseness.
}
\examples{
# will produce lints
lint(
  text = "x[x == '']",
  linters = nzchar_linter()
)

lint(
  text = "x[nchar(x) > 0]",
  linters = nzchar_linter()
)

# okay
lint(
  text = "x[!nzchar(x, keepNA = TRUE)]",
  linters = nzchar_linter()
)

lint(
  text = "x[nzchar(x, keepNA = TRUE)]",
  linters = nzchar_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}
}
