% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_json.R
\name{extract_json}
\alias{extract_json}
\title{Extract and parse JSONs from a string (LLM response)}
\usage{
extract_json(llm_response)
}
\arguments{
\item{llm_response}{A character string}
}
\value{
A list of parsed JSON objects
}
\description{
This function extracts JSON blocks from a string and parses them using `jsonlite::fromJSON()`.
This can be used to extract all JSONs from LLM responses, immediately converting
them to R objects.
}
\details{
CRITICAL FIX: Now uses simplifyVector = FALSE to preserve array structure.
This ensures that JSON arrays remain as R lists, preventing single-element arrays
from being simplified to character vectors. This is essential for proper schema
validation when used with auto_unbox = TRUE in toJSON().
}
