% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_as_json.R
\name{response_as_json}
\alias{response_as_json}
\title{Get JSON response from LLM with validation and retry}
\usage{
response_as_json(
  chat_obj,
  prompt,
  schema = NULL,
  schema_strict = FALSE,
  max_iterations = 3
)
}
\arguments{
\item{chat_obj}{Chat object (LLM client). Must be a properly initialized LLM client instance.}

\item{prompt}{Character string. The user prompt to send to the LLM requesting JSON output.}

\item{schema}{List or NULL. Optional JSON schema for response validation (as R list structure).
When provided, validates the LLM response against this schema. Default is NULL.}

\item{schema_strict}{Logical. Whether to use strict schema validation (no additional properties allowed).
Only applies when schema is provided. Default is FALSE.}

\item{max_iterations}{Integer. Maximum number of retry attempts for invalid JSON or schema validation failures.
Must be positive. Default is 3.}
}
\value{
List. Parsed JSON response from the LLM.
}
\description{
Get JSON response from LLM with validation and retry
}
\examples{
\dontrun{
# Basic usage without schema
result <- response_as_json(
  chat_obj = llm_client,
  prompt = "List three colors"
)

# With schema validation
schema <- list(
  type = "object",
  properties = list(
    equation = list(type = "string"),
    solution = list(type = "number")
  ),
  required = c("equation", "solution")
)
result <- response_as_json(
  chat_obj = llm_client,
  prompt = "How can I solve 8x + 7 = -23?",
  schema = schema,
  schema_strict = TRUE,
  max_iterations = 3
)
}

}
