% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_llm_response.R
\name{get_llm_response}
\alias{get_llm_response}
\title{Get LLM Response with Text or JSON Output}
\usage{
get_llm_response(
  prompt,
  llm_client,
  max_retries = 5,
  max_words = NULL,
  max_characters = NULL,
  json_schema = NULL,
  schema_strict = FALSE,
  schema_type = "auto",
  verbose = NULL,
  stream = NULL,
  clean_chat_history = TRUE,
  return_mode = c("only_response", "full")
)
}
\arguments{
\item{prompt}{A character string or tidyprompt object containing the prompt to send to the LLM.
This is the main input that the LLM will respond to.}

\item{llm_client}{An LLM provider object created by functions like \code{llm_openai()} or
\code{llm_ollama()}. This object contains the configuration for connecting to and
communicating with the specific LLM service.}

\item{max_retries}{Integer. Maximum number of retry attempts if the LLM fails to provide
a valid response (default: 5). The function will retry if:
\itemize{
\item The response doesn't meet validation criteria
\item JSON parsing fails (when using json_schema)
\item Network or API errors occur
If max_retries is exceeded, NULL is returned.
}}

\item{max_words}{Integer or NULL. Maximum number of words allowed in the response
(default: NULL, no limit). Only applies when json_schema is NULL (text responses).
If specified, responses exceeding this limit will trigger a retry.
Example: max_words = 50 limits response to 50 words or fewer.}

\item{max_characters}{Integer or NULL. Maximum number of characters allowed in the response
(default: NULL, no limit). Only applies when json_schema is NULL (text responses).
If specified, responses exceeding this limit will trigger a retry.
Example: max_characters = 280 limits response to Twitter-like length.}

\item{json_schema}{List or NULL. JSON schema specification for structured responses
(default: NULL for text responses). When provided, the LLM will be forced to
return a valid JSON object matching the schema. The schema should be a list
representing a JSON schema structure with:
\itemize{
\item name: Schema identifier
\item description: Schema description
\item schema: The actual JSON schema with type, properties, required fields, etc.
Example: list(name = "person", schema = list(type = "object", properties = ...))
}}

\item{schema_strict}{Logical. Whether to enforce strict schema validation
(default: FALSE). When TRUE:
\itemize{
\item JSON responses must exactly match the schema
\item No additional properties are allowed beyond those specified
\item All required fields must be present
Only applicable when json_schema is provided.
}}

\item{schema_type}{Character. Method for enforcing JSON response format
(default: 'auto'). Options:
\itemize{
\item 'auto': Automatically detect best method based on LLM provider
\item 'text-based': Add JSON instructions to prompt (works with any provider)
\item 'openai': Use OpenAI's native JSON mode (requires compatible OpenAI API)
\item 'ollama': Use Ollama's native JSON mode (requires compatible Ollama model)
\item 'openai_oo': OpenAI mode without schema enforcement in API
\item 'ollama_oo': Ollama mode without schema enforcement in API
}}

\item{verbose}{Logical or NULL. Whether to print detailed interaction logs to console
(default: NULL, uses LLM client's setting). When TRUE:
\itemize{
\item Shows the prompt being sent
\item Displays the LLM's response
\item Reports retry attempts and validation failures
Useful for debugging and monitoring LLM interactions.
}}

\item{stream}{Logical or NULL. Whether to stream the response in real-time
(default: NULL, uses LLM client's setting). When TRUE:
\itemize{
\item Response appears progressively as the LLM generates it
\item Provides faster perceived response time
\item Only works if the LLM provider supports streaming
Note: Streaming is automatically disabled when verbose = FALSE.
}}

\item{clean_chat_history}{Logical. Whether to clean chat history between retries
(default: TRUE). When TRUE:
\itemize{
\item Keeps only essential messages in context (first/last user message, last assistant message, system messages)
\item Reduces context window usage on retries
\item May improve performance with repeatedly failing responses
When FALSE, full conversation history is maintained.
}}

\item{return_mode}{Character. What information to return (default: "only_response"). Options:
\itemize{
\item "only_response": Returns only the processed LLM response (character string or parsed JSON)
\item "full": Returns a comprehensive list containing:
\itemize{
\item response: The processed LLM response
\item interactions: Number of interactions with the LLM
\item chat_history: Complete conversation history
\item chat_history_clean: Cleaned conversation history
\item start_time: When the function started
\item end_time: When the function completed
\item duration_seconds: Total execution time
\item http_list: Raw HTTP responses from the API
}
}}
}
\value{
Depends on return_mode parameter:
\itemize{
\item If return_mode = "only_response": Character string (text mode) or parsed list (JSON mode)
\item If return_mode = "full": Named list with response and metadata
\item NULL if all retry attempts fail
}
}
\description{
This function sends a prompt to a Language Learning Model (LLM) and returns either
a text response or a JSON-structured response based on the provided parameters.
It handles retries, validation, and response formatting automatically.
}
\details{
This function serves as a unified interface for getting responses from LLMs with
automatic handling of different response formats and validation. It internally uses
the tidyprompt package's \code{answer_as_text()} or \code{answer_as_json()} functions
depending on whether a JSON schema is provided.

\strong{Text Mode (json_schema = NULL):}
\itemize{
\item Uses \code{answer_as_text()} with optional word/character limits
\item Returns plain text responses
\item Validates response length constraints
}

\strong{JSON Mode (json_schema provided):}
\itemize{
\item Uses \code{answer_as_json()} with schema validation
\item Forces structured JSON responses
\item Validates against provided schema
\item Returns parsed R objects (lists)
}

\strong{Error Handling:}
The function automatically retries on various failure conditions including
validation errors, JSON parsing errors, and network issues.
}
\examples{
\dontrun{
# Basic text response
client <- llm_ollama()
response <- get_llm_response("What is R?", client)

# Text response with word limit
short_response <- get_llm_response(
  "Explain machine learning",
  client,
  max_words = 50
)

# JSON response with schema
schema <- list(
  name = "person_info",
  schema = list(
    type = "object",
    properties = list(
      name = list(type = "string"),
      age = list(type = "integer")
    ),
    required = c("name", "age")
  )
)

json_response <- get_llm_response(
  "Create a person with name and age",
  client,
  json_schema = schema
)

# Full response with metadata
full_result <- get_llm_response(
  "Hello",
  client,
  return_mode = "full",
  verbose = TRUE
)
}

}
\author{
Zaoqu Liu; Email: liuzaoqu@163.com
}
