% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io_functions.R
\name{save_spatial_data}
\alias{save_spatial_data}
\title{Save Spatial Data}
\usage{
save_spatial_data(
  data,
  file_path = NULL,
  scale = "huc8",
  nutrient = "both",
  analysis_type = "combined",
  year = format(Sys.Date(), "\%Y")
)
}
\arguments{
\item{data}{sf object. Spatial data to save}

\item{file_path}{Character. Output file path (should end in .rds). If NULL, auto-generated}

\item{scale}{Character. Spatial scale for file naming}

\item{nutrient}{Character. Nutrient type for file naming ("nitrogen", "phosphorus", or "both")}

\item{analysis_type}{Character. Analysis type for file naming}

\item{year}{Numeric. Year for file naming}
}
\value{
Character. Path to saved file
}
\description{
Save spatial data to RDS file with standardized naming
}
\examples{
\donttest{
# Create some example results first
results <- run_builtin_analysis(scale = "county", year = 2016)

# Save with auto-generated filename
save_spatial_data(results$agricultural, scale = "county", year = 2016)

# Save with custom filename
save_spatial_data(results$agricultural,
                  file.path(tempdir(), "my_results.rds"))
}
}
