% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfdistS.R
\name{ecdfdistS}
\alias{ecdfdistS}
\title{Distance Measures between Samples through Empirical Cumulative Distribution Functions}
\usage{
ecdfdistS(
  veclist,
  method = c("KS", "Lp", "Wasserstein"),
  p = 1,
  as.dist = FALSE
)
}
\arguments{
\item{veclist}{a length \eqn{N} list of vectors.}

\item{method}{name of the distance/dissimilarity measure. Case insensitive (default: \code{ks}).}

\item{p}{exponent for \code{Lp} or \code{Wasserstein} distance (default: \code{p=1}).}

\item{as.dist}{a logical; \code{TRUE} to return \code{dist} object, \code{FALSE} to return an \eqn{(N\times N)} symmetric matrix of pairwise distances (default: \code{FALSE}).}
}
\value{
either \code{dist} object of an \eqn{(N\times N)} symmetric matrix of pairwise distances by \code{as.dist} argument.
}
\description{
We measure distance between two empirical cumulative distribution functions of the data. 
Unlike \code{\link[maotai]{ecdfdist}}, this function takes raw data samples as input, and 
internally computes the empirical cumulative distribution functions (ECDF) for distance calculations.
}
\examples{
\donttest{
## toy example : 10 of random and uniform distributions
mylist = list()
for (i in 1:10){
  mylist[[i]] = stats::rnorm(50, sd=2)
}
for (i in 11:20){
  mylist[[i]] = stats::runif(50, min=-5)
}

## compute three distances
d_KS = ecdfdistS(mylist, method="KS")
d_LP = ecdfdistS(mylist, method="Lp")
d_OT = ecdfdistS(mylist, method="Wasserstein")

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
image(d_KS[,nrow(d_KS):1], axes=FALSE, main="Kolmogorov-Smirnov")
image(d_LP[,nrow(d_LP):1], axes=FALSE, main="Lp (p=1)")
image(d_OT[,nrow(d_OT):1], axes=FALSE, main="Wasserstein (p=1)")
par(opar)
}

}
