% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_symb.R
\name{mf_symb}
\alias{mf_symb}
\title{Plot symbols}
\usage{
mf_symb(
  x,
  var,
  pal = "Dynamic",
  alpha = NULL,
  rev = FALSE,
  border,
  pch,
  cex = 2,
  lwd = 0.7,
  col_na = "grey",
  pch_na = 4,
  cex_na = 1,
  val_order,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_no_data = "No data",
  leg_frame = FALSE,
  leg_frame_border,
  leg_adj = c(0, 0),
  leg_fg,
  leg_bg,
  leg_size = 1,
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{alpha}{opacity, in the range [0,1]}

\item{rev}{if \code{pal} is a \link{hcl.colors} palette name, whether the ordering of the colors should be reversed (TRUE) or not (FALSE)}

\item{border}{border color}

\item{pch}{pch (point type) for symbols}

\item{cex}{cex (point size) for symbols}

\item{lwd}{border width}

\item{col_na}{color for missing values}

\item{pch_na}{point type for NA values}

\item{cex_na}{point size for NA values}

\item{val_order}{values order, a character vector that matches var modalities}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos = NA then the legend is not plotted. If leg_pos = 'interactive' click onthe map to choose the legend position.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{leg_frame_border}{border color of the legend frame}

\item{leg_adj}{adjust the postion of the legend in x and y directions}

\item{leg_fg}{color of the legend foreground}

\item{leg_bg}{color of the legend backgournd}

\item{leg_size}{size of the legend; 2 means two times bigger}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot symbols based on qualitative data.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_map(mtq, "STATUS", "symb")

mtq[6, "STATUS"] <- NA
mf_map(mtq)
mf_map(
  x = mtq, var = "STATUS", type = "symb",
  pch = c(21:23), pal = c("red1", "tan1", "khaki1"),
  border = "grey20", cex = c(1.5, 1, .9), lwd = .5,
  val_order = c("Prefecture", "Sub-prefecture", "Simple municipality"),
  pch_na = 24, leg_frame = TRUE
)
}
\keyword{internal}
