% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F03.R
\name{F03}
\alias{F03}
\title{Sum of Squared Cumulative Sums (F03)}
\usage{
F03(x)
}
\arguments{
\item{x}{Numeric vector of input values.}
}
\value{
Numeric scalar representing the function value.
}
\description{
A unimodal test function that calculates the sum of squared cumulative sums,
also known as the Schwefel 2.22 variant.
}
\details{
\strong{Formula:}
\deqn{f(x) = \sum_{i=1}^{n} \left(\sum_{j=1}^{i} x_j\right)^2}{
  f(x) = sum_{i=1}^n (sum_{j=1}^i x_j)^2}

\strong{Global minimum:} \eqn{f(0, 0, ..., 0) = 0}

\strong{Characteristics:}
\itemize{
  \item Type: Unimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Convex: Yes
  \item Default bounds: \eqn{[-100, 100]^n}
  \item Default dimensions: 50
}

This function is non-separable because each term depends on all previous
variables, making it useful for testing algorithms' ability to handle
variable dependencies.
}
\examples{
F03(c(0, 0, 0))    # Returns 0 (global minimum)
F03(c(1, 2, 3))    # Returns 1^2 + (1+2)^2 + (1+2+3)^2 = 1 + 9 + 36 = 46

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters.
}
